<?php
/*
Template Name: Ask Page
*/
?>
<?php get_header() ?>
<?
    if(qtrans_getLanguage()=='en') { 
        $required_info = 'required information'; 
        $email_address = 'E-mail Address';
        $what_state = 'What City and State do you live in?';
        $question = 'What would you you like to ask us?';
        $optional_info = 'OPTIONAL INFORMATION';
        $your_name = 'Your Name';
        $your_address = 'Your Address';
        $your_state = 'State';
        $your_city = 'City';
        $your_zip = 'Zip Code';
        $your_phone = 'Phone';
        $best_to_contact = 'How is it best to contact you?';
        $choose = 'Choose One';
        $by_phone = 'By Phone';
        $by_email = 'By Email';
        $website = 'How did you find this website?';
        $from_internet = 'From the Internet';
        $from_friend = 'From my friend';
        $from_ad = 'From ads';
        $others = 'Others';
        $done = 'When done, please';
        $or = 'or';
        $submit = 'Submit';
        $clear = "Clear Form";
        $success_msg = 'You have successfully sent your question!';
        
    }
    elseif(qtrans_getLanguage()=='ru') { 
        $required_info = 'НЕОБХОДИМАЯ ИНФОРМАЦИЯ'; 
        $email_address = 'Ваш "e-mail"  адрес';
        $what_state = 'В каком городе и штате Вы живете?';
        $question = 'Что бы Вы хотели спросить?';
        $optional_info = 'ВЫБОРОЧНАЯ ИНФОРМАЦИЯ';
        $your_name = 'Ваша Имя';
        $your_address = 'Ваш Адрес';
        $your_state = 'Штат';
        $your_city = 'Город';
        $your_zip = 'Почтовый индекс';
        $your_phone = 'Номер телефона';
        $best_to_contact = 'Как лучше связыватся с вами';
        $choose = 'Выберите один из список';
        $by_phone = 'по телефону';
        $by_email = 'по эмайлу';
        $website = 'Как Вы узнали о нашем website?';
        $from_internet = 'Поиск на Интернете';
        $from_friend = 'Наш предыдущий клиент';
        $from_ad = 'Другой website';
        $others = 'Другое';
        $done = 'Когда закончили пожалуйста';
        $or = 'или';
        $submit = 'Отправите';
        $clear = "Очистите Форму";
        $success_msg = 'Вы Успешно отправили свой вопрос!';    
    }
    elseif(qtrans_getLanguage()=='es') { 
        $required_info = 'INFORMACIÓN REQUERIDA'; 
        $email_address = 'Dirección de correo electrónico (e-mail)';
        $what_state = '¿Qué ciudad y el estado vive usted?';
        $question = '¿Qué desea preguntar?';
        $optional_info = 'INFORMACIÓN OPCIONAL';
        $your_name = 'su nombre';
        $your_address = 'Su dirección';
        $your_state = 'Estado';
        $your_city = 'La ciudad';
        $your_zip = 'El código postal';
        $your_phone = 'El número telefónico';
        $best_to_contact = '¿Cuál es la mejor manera de comunicarnos con usted?';
        $choose = 'elegir uno';
        $by_phone = 'por teléfono';
        $by_email = 'por correo electrónico';
        $website = '¿Cómo supo usted acerca de este sitio de la red? ';
        $from_internet = 'A través de Internet';
        $from_friend = 'De mi amigo';
        $from_ad = 'de los anuncios';
        $others = 'otros';
        $done = 'Cuando termine, por favor';
        $or = 'o';
        $submit = 'presentar';
        $clear = "forma clara";    
        $success_msg = 'Ha enviado su pregunta!';
    }


?>
	<div class="content"> 
	   <div class="content_bar">
           <h1><?php the_title() ?></h1>
    		<?php the_post() ?>   
    		<?php the_content() ?>
    		<div class="content_form">
                <form id="askForm" action="<?=get_permalink()?>" method="post">
        			<div class="ask_block">
        				<div class="ask_form">
        					<p><?=$required_info?></p>
                            <label>*<?=$your_name?></label><input id="full_name" name="full_name" value="" />
        					<label>*<?=$email_address?></label><input id="email" name="email" class="required" />			
        					<label>*<?=$what_state?></label><input id="state" name="state" class="required"  />			
        					<label>*<?=$question?></label><textarea id="message" name="message" class="required" rows="" cols="" ></textarea>
        				</div>
        		
        				<div class="ask_input">
        					<p><?=$optional_info?></p>
        					<label><?=$your_address?></label><input name="address" value="" />
        					<label><?=$your_city?></label><input name="city" value=""  />
        					<label><?=$your_state?></label><input name="state2" value=""  />
                            <label><?=$your_zip?></label><input name="zip" value=""  />
        					<label><?=$your_phone?></label><input name="phone" value="" />
        	
        					<label><?=$best_to_contact?></label><select name="contact_option">
        						<option value="-"><?=$choose?></option>
        						<option value="<?=$by_phone?>"><?=$by_phone?></option>
        						<option value="<?=$by_email?>"><?=$by_email?></option>
        					</select>
        					
        					<label><?=$website?></label><select name="find_website">
        						<option value="-"><?=$choose?></option>
        						<option value="<?=$from_internet?>"><?=$from_internet?></option>
        						<option value="<?=$from_friend?>"><?=$from_friend?></option>
        						<option value="<?=$from_ad?>"><?=$from_ad?></option>
        						<option value="<?=$others?>"><?=$others?></option>
        					</select>
        				</div>
        			</div><!--/ask_block-->
        			
        			<div class="ask_submit">
        				<p><?=$done?> <input name="doSubmit" type="submit" value="<?=$submit?>" onclick="if(this.value=='E-Mail Address') this.value=''"/> <?=$or?> <input type="reset" value="<?=$clear?>" /></p>
        			</div> 
                    
        		</form>
            </div>
        </div>
	</div><!-- #content -->

<?php get_footer() ?>
<script type="text/javascript">
$().ready(function() {
    	// validate signup form on keyup and submit
	$("#askForm").validate({
		rules: {
		    full_name: {
		        required: true,  
		    },
			email: {
				required: true,
				email: true
			},
			state: {
				required: true,
				minlength: 2
			},
			message: {
			    required: true,
            }
		},
		messages: {
		    full_name: {
		        required: "Please, enter your full name",  
		    },
			email: {
				required: "Please enter your email",
				email: "Please enter a valid email address"
			},
			state: {
				required: "Please provide your State",
			},
			message: {required: "Please write your question"}
		}
	});

});
</script>
<style type="text/css">
#askForm label.error {
	width: 350px;
    margin-bottom:10px;
	display: inline-block;
    color:red;
}
</style>

<?php
    ini_set('display_errors','on');
    if(isset($_POST['doSubmit'])){
        foreach($_POST as $key => $value) 
        {
    	   $data[$key] = $value;
        }

        $my_mail = get_settings('admin_email');
        
        $full_name = $data['full_name'];       
        $email = $data['email'];
        $state = $data['state'];
        $message = $data['message'];
        $address = $data['address'];
        $state2 = $data['state2'];
        $city = $data['city'];
        $zip = $data['zip'];
        $phone = $data['phone'];
        $contact_option = $data['contact_option'];
        $find_website = $data['find_website'];
        
        

        $full_address = array($address, $city, $zip);
        $full_address = implode(', ', array_filter($full_address));
        if($full_address)
        {
            $full_address = "Address: ".$full_address."\r\n";
        }
        if($phone)
        {
            $get_phone = "Phone: ".$phone."\r\n";
        }
        if($contact_option != '-')
        {
            $get_contact_option = "Contact Option: ".$contact_option."\r\n";
        }
        if($find_website != '-')
        {
            $get_find_website = "Referral: ".$find_website."\r\n";
        }
         
        $content = "
        From: $full_name, $state \r\n 
        Email: $email \r\n
        $full_address 
        $get_phone
        $get_contact_option
        $get_find_website         
        Message: $message ";            


        
        if(mail($my_mail,'ASK YOUR QUESTION',$content,"From: $email")){ ?>
          <script>
            window.alert('<?=$success_msg?>');
            window.location = '<?=get_permalink()?>';
          </script>
       <? } else { ?>
          <script>
            window.alert('Ooops, something went wrong. Please, try again.');
            window.location = '<?=get_permalink()?>';            
          </script>
       <? }
    }
    
?>