<?php
class Authentication extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		
		$this->load->library('auth');
	}
	
	public function login()
	{
		if (!$this->auth->is_logged_in())
		{
			$this->form_validation->set_rules('username', 'Username', 'trim|required|xss_clean');
			$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');
			$this->form_validation->set_rules('remember', 'Remember me', 'integer');
			$this->form_validation->set_error_delimiters('<span class="error">', '</span>');
			
			if ($this->auth->is_max_login_failed())
			{
				$this->form_validation->set_rules('captcha', 'Confirmation Code', 'trim|required|xss_clean|callback_captcha_check');
			}
				
			if ($this->form_validation->run() AND $this->auth->login($this->input->post('username'), $this->input->post('password'))===TRUE)
			{
				
				$uri = $this->session->flashdata('referrer') ? $this->session->flashdata('referrer') : '';
				redirect($uri);
			}
			else
			{
				$this->session->keep_flashdata('referrer');
				
				$data['show_captcha'] = FALSE;
				
				if ($this->auth->is_max_login_failed())
				{
					$this->auth->captcha();

					$data['show_captcha'] = TRUE;
				}
				$this->template->load('login', $data, TRUE);
			}
		}
		else
		{
			redirect('', 'location');
		}
	}	
	
	public function logout()
	{
		$this->auth->logout();
		redirect('');
	}
	
}