<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Calendar extends MY_Controller 
{
	private $data = array();
	
	public function __construct()
	{
		parent::__construct();
		
		
	}
	
	public function index()
	{
		$this->load->library('calendar', config_item("calendar"));	
		
		$year = $this->uri->segment(2, date('Y'));
		$month = $this->uri->segment(3, date('m'));
		
		$timeline = $this->crm_model->get_current_projects($year, $month);
		
		$date = $year.'-'.$month;
		
		$data = array();
		
		for($i=1; $i<=date('t');$i++)
		{
			$day = $date.'-'.($i>9?$i:"0{$i}");
			
			$days[$i] = $day;			
		}
		
		$s = 0;
		foreach($timeline as $time)
		{				
			$range = $this->date_range($time->start_date, $time->end_date);
					
			foreach($range as $row)
			{
				if($key = array_search($row, $days))
				{
					$data[$key][$s] = array('title' => $time->title, 'style'=>$time->style, 'link' => site_url('/projects/view/'.$time->project_id));
				}
			}
						
			$s++;
		}		

		$this->data['calendar'] = $this->calendar->generate($year, $month, $data);

		$this->template->load('calendar/index', $this->data);
	}
	
	private function date_range($start, $end)
	{
		$array = array($start);
		$start_time = strtotime($start);		
		$end_time = strtotime($end);
		
		if($end>=$start)
		{
			while($start_time<$end_time)
			{
				$start_time+=86400;
				$array[] = date("Y-m-d", $start_time);
			}
		}
		
		return $array;
	}
}

/* End of file calendar.php */
/* Location: ./application/controllers/calendar.php */