<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Developers extends MY_Controller 
{
	private $data = array();
	
	private $validation_rules = array(
		array(
			'field' => 'name',
			'label' => 'Name',
			'rules' => 'trim|required'
		),
		array(
			'field' => 'email',
			'label' => 'Email',
			'rules' => 'trim|valid_email'
		)
	);
	
	
	public function index()
	{		
		$this->load->library('pagination');
		
		$this->data['total'] = $this->crm_model->get_total_developers();

		$config['base_url'] = site_url("developers/index");
		$config['total_rows'] = $this->data['total'];
		$config['per_page'] = 20;
		$config['uri_segment'] = 3;
		
		$this->pagination->initialize($config);
		
		$this->data['pagination'] = $this->pagination->create_links();

		$this->data['developers'] = $this->crm_model->get_all_developers($config['per_page'],$this->uri->segment($config['uri_segment']));		
		
		$this->template->load('developers/index', $this->data);
	}
	
	public function create()
	{
		$this->form_validation->set_rules($this->validation_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("name"	=> $this->input->post("name"),
							"email"	=> $this->input->post("email"));
			
			$project_id = $this->crm_model->create_developer($fields);
			
			$this->session->set_flashdata("msg", "Developer successfully created");
			
			redirect('developers');
		}
		else 
		{
			$this->template->load('developers/create', $this->data);
		}
	}
	
	public function edit($id)
	{
		
		$developer = $this->crm_model->get_developer($id);
		if(empty($developer))
		{
			$this->session->set_flashdata('msg', 'Developer not found!');	
			redirect('developers');
		}
		
		$this->form_validation->set_rules($this->validation_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("name"	=> $this->input->post("name"),
							"email"	=> $this->input->post("email"));
			
			$this->crm_model->update_developer($developer->developer_id, $fields);
						
			$this->session->set_flashdata("msg", "Developer successfully updated");
			
			redirect('developers');
		}
		else 
		{
			$this->data['developer'] = $developer;

			$this->template->load('developers/edit', $this->data);
		}
	}
	
}

/* End of file developers.php */
/* Location: ./application/controllers/developers.php */