<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notifications extends MY_Controller 
{
	private $data = array();
	
	private $validation_rules = array(
		array(
			'field' => 'title',
			'label' => 'Project Title',
			'rules' => 'trim|required'
		),
		array(
			'field' => 'project',
			'label' => 'Project',
			'rules' => 'trim|required'
		),
		array(
			'field' => 'developer',
			'label' => 'Developer',
			'rules' => 'trim|'
		),
		array(
			'field' => 'date',
			'label' => 'date',
			'rules' => 'trim|required'
		),
		array(
			'field' => 'time',
			'label' => 'Time',
			'rules' => 'trim'
		),
		array(
			'field' => 'email',
			'label' => 'Email',
			'rules' => 'trim|valid_email'
		)
	);
	
	public function __construct()
	{
		parent::__construct();
		
		$this->load->model("notifications_model");
	}
	
	
	
	public function create($date)
	{
		if($date < date('Y-m-d'))
		{
			show_error("You cannot add notification to past date.");			
		}	
		
		$this->form_validation->set_rules($this->validation_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$time = $this->input->post("date").' '.$this->input->post("time");
			
			$fields = array("title"			=> $this->input->post("title"),
							"project_id"	=> $this->input->post("project"),
							"time"			=> date('Y-m-d H:i:s', strtotime($time)),
							"email"			=> $this->input->post("email"),
							"status" 		=> 0);
			
			$this->notifications_model->create_notification($fields);
			
			$this->session->set_flashdata("msg", "Notification successfully created");
			
			redirect('/calendar');
		}
		else 
		{
			$this->data['date'] = $date;
			$this->data['projects'] = $this->crm_model->get_todays_projects($date);

			$this->template->load('notifications/create', $this->data);
		}
	}
	
}

/* End of file projects.php */
/* Location: ./application/controllers/projects.php */