<?php
/**
 * COMMOIR
 *
 * File description
 * - 
 * - 
 *
 * @author		Ulugbek D.
 * @link		http://commonir.com
 * @since		Version 0.1
 */
 
class Files extends MY_Controller
{
	public $data = array();
	
	protected $_validation_rules = array(
		array(
			'field' => 'project',
			'label' => 'project',
			'rules' => 'trim|xss_clean'
		),
		array(
			'field' => 'userfile',
			'label' => 'userfile',
			'rules' => 'trim|xss_clean|callback__upload_file'
		)
	);
	
	public $_upload_dir = './files/';
	
	public function __construct()
	{
		parent::__construct();
		
		$this->project();
		
		$this->output->enable_profiler(FALSE);
		
		$this->load->model('files_model');
		
		$this->load->helper('text');	
	}
	
	public function index()
	{
		$this->data['files'] = $this->files_model->get_project_files($this->data['project']->project_id);
		
		$this->template->metas("meta_title", 'Files - '.$this->data['project']->title);		
		
		$this->template->load('files/list', $this->data);
	}
	
	public function add()
	{
		$this->template->metas("meta_title", 'Add files - '.$this->data['project']->title);		
		
		$this->template->load('files/add', $this->data);
	}
	
	public function delete($file_id)
	{
		$file = $this->files_model->get_file($file_id);
		
		if(empty($file))
		{
			$this->session->set_flashdata('msg', 'File was not found!');	
			redirect("/p/{$this->data['project']->alias}/files/");
		}
		
		$this->files_model->delete_file($file->file_id);
		
		unlink("./files/{$this->data['project']->project_id}/{$file->filename}");
		
		$logg = array('project'		=> $this->data['project'],
					  'type'		=> 'file',
					  'type_id'		=> $file_id,
					  'action'		=> 'delete',
					  'content'		=> $file->filename,
					  'url'			=> "file/{$this->data['project']->project_id}/{$file->filename}");
		//log
		$this->events->log($logg);
			
		$this->session->set_flashdata("msg", "File successfully deleted!");
			
		redirect("/p/{$this->data['project']->alias}/files/");
	}

	public function upload()
	{	
		$return = array();
		
		$this->form_validation->set_rules($this->_validation_rules);
		
		$this->form_validation->set_error_delimiters("","");
		
		if($this->form_validation->run() === TRUE)
		{			
			$file = $this->session->userdata('file');
			
			$fields = array('project_id'	=> $this->data['project']->project_id,
							'user_id'		=> $this->auth->get_user_id(),
							'filename'		=> $file['file_name'],
							'extension'		=> substr($file['file_ext'],1),
							'size'			=> $file['file_size'],
							'mime'			=> $file['file_type'],
							'created'		=> date('Y-m-d H:i:s'),
							'status'		=> 1);
			
			$file_id = $this->files_model->add_file($fields);
			
			$logg = array('project'		=> $this->data['project'],
						  'type'		=> 'file',
						  'type_id'		=> $file_id,
						  'action'		=> 'upload',
						  'content'		=> $file['file_name'],
						  'url'			=> "file/{$this->data['project']->project_id}/{$file['file_name']}");
			//log
			$this->events->log($logg);		
			
			$this->session->unset_userdata("file");
				
			$return['code'] = 200;	
			$return['message'] = array('id' => $file_id, 'name' => $file['file_name'], 'ext' => substr($file['file_ext'],1));
		}
		else
		{
			$return['code'] = 404;
			$return['message'] = strip_tags(validation_errors());
		}
		
		$this->output->set_content_type('application/json')
    				 ->set_output(json_encode($return));
	}
	
	public function _upload_file()
	{
		if (!empty($_FILES['userfile']['name'])) 
		{
			$this->form_validation->set_error_delimiters("","");
			
			if(!isset($this->data['project']))
			{
				$this->form_validation->set_message('_upload_file', 'Project was not selected or you do not have access.');			
				return FALSE;
			}
			
			$this->_upload_dir .= $this->data['project']->project_id.'/';

			if(! is_dir($this->_upload_dir))
			{
				@mkdir($this->_upload_dir);
				@chmod($this->_upload_dir, 0755);
			}
			
			$config['upload_path'] = $this->_upload_dir;
			$config['allowed_types'] = 'gif|jpg|png|jpeg|pdf|zip|rar|psd|doc|docx|txt|pps|csv|xls|xlsx';
			$config['max_size']	= '15000';
	
			$this->load->library('upload', $config);
	
			if ( ! $this->upload->do_upload())
			{
				$this->form_validation->set_message('_upload_file', $this->upload->display_errors());			
				return FALSE;			
			}
			else
			{
				$file = $this->upload->data();
				
				
				if($file['is_image'])
				{
					$resize = $this->resize_image($file);
					
					if(!empty($resize))
					{
						$this->form_validation->set_message('_upload_file', $resize);			
						return FALSE;
					}
				}
				
				$this->session->set_userdata("file", $file);					
			}
		}
		else
		{
			$this->form_validation->set_message('_upload_file', 'Upload file not set');			
			return FALSE;	
		}
		
		return TRUE;
	}
	
	private function resize_image($image)
	{
		//error counter
		$error = array();
		
		$this->load->library('image_lib');
		
		//set original image, absolute path
		$original = $this->_upload_dir.$image['file_name'];

		$config['image_library'] = 'gd2';
		$config["source_image"] = $original;
		$config['create_thumb'] = TRUE;
        $config["width"] = 100;
        $config["height"] = 100;
        $config["dynamic_output"] = FALSE;
        $config['maintain_ratio'] = TRUE;
        
        $this->image_lib->initialize($config); 
        
        if(! $this->image_lib->resize())
        {
        	$error = $this->image_lib->display_errors();
        }
        
   		$this->image_lib->clear();  
		
				
		return $error;	
	}
}


/* End of file time.php */