<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Project name
 *
 * File description
 *
 * @author		Ulugbek D.
 * @since		Version 1.0
 * @filesource
 */

class Tasks extends MY_Controller
{
	private $validation_rules = array(
		array(
			'field' => 'title',
			'label' => 'List name',
			'rules' => 'trim|required'
		),
		array(
			'field' => 'access',
			'label' => 'access',
			'rules' => 'trim'
		),
		array(
			'field' => 'description',
			'label' => 'Description',
			'rules' => 'trim|'
		)
	);
	
	private $task_rules = array(
		array(
			'field' => 'task',
			'label' => 'Task item',
			'rules' => 'trim|required|htmlspecialchars'
		),
		array(
			'field' => 'priority',
			'label' => 'Priority',
			'rules' => 'trim|'
		),
		array(
			'field' => 'duedate',
			'label' => 'Due Date',
			'rules' => 'trim|'
		)
	);
	
	
	private $comments_rules = array(
		array(
			'field' => 'comment',
			'label' => 'Comment',
			'rules' => 'trim|'
		)
	);
	
	public function __construct()
	{
		parent::__construct();
		
		$this->project();
		
		$this->load->model('tasks_model');
		$this->load->model('projects_model');
	}
	
	public function index()
	{		
		$lists = $this->tasks_model->get_project_lists($this->data['project']->project_id);
		
		$c = 0;
		if($lists)
		{
			foreach ($lists as $row)
			{
				$lists[$c]->tasks = $this->tasks_model->get_list_tasks($row->list_id, 1);
				
				$c++;
			}
		}
		
		$this->data['lists'] = $lists;
				
		$this->template->metas("meta_title", 'Tasks - '.$this->data['project']->title);		
		$this->template->load('tasks/list', $this->data);
	}
	
	public function show($list_id, $status='')
	{		
		$this->data['list'] = $this->tasks_model->get_list($list_id);
		
		if(empty($this->data['list']))
		{
			$this->session->set_flashdata('msg', 'Task list not found!');		
					
			redirect('p/'.$this->data['project']->alias.'/tasks');
		}
		
		$stat = $status=='completed' ? 2 : FALSE;
		
		$this->data['tasks'] = $this->tasks_model->get_list_tasks($this->data['list']->list_id, $stat);
				
		$this->template->metas("meta_title", $this->data['list']->title.' Tasks - '.$this->data['project']->title);		
		
		$this->template->load('tasks/show', $this->data);
	}
	
	public function comments($task_id)
	{
		$this->load->model('files_model');
		
		$this->load->helper('text');
			
		$this->data['task'] = $this->tasks_model->get_task($task_id);
		
		if(empty($this->data['task']))
		{
			$this->session->set_flashdata('msg', 'Task not found!');	
			redirect('p/'.$this->data['project']->alias.'/tasks');
		}
		
		$this->data['comments'] = $this->tasks_model->get_task_comments($task_id);
		
		$this->form_validation->set_rules($this->comments_rules);
		
		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("task_id"		=> $task_id,
							"user_id"		=> $this->auth->get_user_id(),
							"comment"		=> $this->input->post("comment"),		
							"status" 		=> 1,
							"created" 		=> date('Y-m-d H:i:s'));
			
			$comment_id = $this->tasks_model->create_comment($fields);
			
			if($files = $this->input->post('files'))
			{
				$this->load->model('files_model');

				$this->files_model->update_comment_file($files, array('comment_id' => $comment_id));
			}
			
			//log and send email
			$email = FALSE;
			
			$logg = array('project'		=> $this->data['project'],
						  'type'		=> 'task',
						  'type_id'		=> $this->data['task']->task_id,
						  'action'		=> 'comment',
						  'content'		=> $this->data['task']->task,
						  "comment" 	=> $this->input->post("comment"),	
						  'url'			=> "/p/{$this->data['project']->alias}/tasks/comments/{$this->data['task']->task_id}#{$comment_id}");
			
			$users = $this->projects_model->get_project_users($this->data['project']->project_id, '', TRUE);
			if($users)
			{
				$emails = array();
				
				foreach($users as $row)
				{
					if($row->user_id != $this->auth->get_user_id())
						$emails[] = $row->email;
				}
				
				
				$logg['to'] = $emails;
				
				$email = 'New_comment_posted_on_task';		
			}
			//log
			$this->events->log($logg, $email);			
			
			$this->session->set_flashdata("msg", "Comment successfully created");
			
			redirect("/p/{$this->data['project']->alias}/tasks/comments/{$this->data['task']->task_id}");
		}
							
		$this->template->metas("meta_title", character_limiter($this->data['task']->task, 20));	
			
		$this->template->load('tasks/view', $this->data);
	}
	
	public function add($list_id)
	{		
		$list = $this->tasks_model->get_list($list_id);
		
		if(empty($list))
		{
			$this->session->set_flashdata('msg', 'Task list not found!');	
			
			redirect('p/'.$this->data['project']->alias.'/tasks');
		}
				
		$this->form_validation->set_rules($this->task_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("list_id"		=> $list->list_id,
							"user_id"		=> $this->auth->get_user_id(),
							"task"			=> $this->input->post("task"),		
							"due_date" 		=> date('Y-m-d',strtotime($this->input->post("duedate"))),	
							"priority"		=> $this->input->post("priority"),		
							"status" 		=> 1,
							"created" 		=> date('Y-m-d H:i:s'));
			
			$task_id = $this->tasks_model->create_task($fields);
			
			
			//log and send email			
			$email = FALSE;
			
			$logg = array('project'		=> $this->data['project'],
						  'type'		=> 'task',
						  'type_id'		=> $task_id,
						  'action'		=> 'add',
						  'content'		=> $this->input->post("task"),
						  "duedate" 	=> $this->input->post("duedate"),	
						  "priority" 	=> $this->input->post("priority"),
						  'url'			=> "/p/{$this->data['project']->alias}/tasks/show/{$list->list_id}");

			$users = $this->projects_model->get_project_users($this->data['project']->project_id, 2);
			
			if($users)
			{
				$emails = array();
				
				foreach($users as $row)
				{
					$emails[] = $row->email;
				}
				
				$logg['to'] = $emails;
				
				$email = 'New_task_submitted';
			}			
			//log
			$this->events->log($logg, $email);			
			
			$this->session->set_flashdata("msg", "Task successfully created");
			
			redirect("/p/{$this->data['project']->alias}/tasks/#{$list->list_id}");
		}
		else 
		{
			$this->template->load('tasks/add', $this->data);
		}
	}
	
	public function edit($task_id)
	{		
		$task = $this->tasks_model->get_task($task_id);
		
		if(empty($task))
		{
			$this->session->set_flashdata('msg', 'Task was not found!');	
			
			return;
		}
				
		$this->form_validation->set_rules($this->task_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("task"			=> $this->input->post("task"),									
							"status" 		=> $task->status,
							"due_date" 		=> date('Y-m-d',strtotime($this->input->post("duedate"))),	
							"priority"		=> $this->input->post("priority"));
			
			$this->tasks_model->update_task($task->task_id, $fields);
			
			$this->session->set_flashdata("msg", "Task successfully created");
			
			redirect("/p/{$this->data['project']->alias}/tasks/#{$task->list_id}");
		}
		else 
		{
			$this->data['task'] = $task;
			$this->template->load('tasks/edit', $this->data);
		}
	}
	
	public function delete($task_id)
	{
		$task = $this->tasks_model->get_task($task_id);
		
		if(empty($task))
		{
			$this->session->set_flashdata('msg', 'Task was not found!');	
			redirect("/p/{$this->data['project']->alias}/tasks/");
		}
		
		if($this->tasks_model->get_task_comments($task->task_id))
		{
			$this->session->set_flashdata('msg', 'Task cannot be deleted! It has comments. Please delete comments first.');	
			redirect("/p/{$this->data['project']->alias}/tasks/comments/{$task->task_id}");
		}
		
		$this->tasks_model->delete_task($task->task_id);
			
		$this->session->set_flashdata("msg", "Task successfully deleted!");
			
		redirect("/p/{$this->data['project']->alias}/tasks/show/{$task->list_id}");
				
	}
	
	public function complete($task_id)
	{
		$this->output->enable_profiler(FALSE);
		
		if(! $this->input->is_ajax_request())
		{
			exit;
		}
		
		$task = $this->tasks_model->get_task($this->input->post("task_id"));
		
		if(empty($task))
		{
			$return['code'] =  404;
			$return['msg'] = 'Task does not exist';
		}
		else 
		{
			$type = $this->input->post("type") ? 2 : 1;
			
			$fields = array("status" => $type);
			
			if($type == 2)
			{
				$fields['completed_time'] = date('Y-m-d H:i:s');
				$fields['completed_by'] = $this->auth->get_user_id();
			}
			
			$this->tasks_model->update_task($task->task_id, $fields);
			
			//log and send email
			$email = FALSE;
			
			$logg = array('project'		=> $this->data['project'],
						  'type'		=> 'task',
						  'type_id'		=> $task->task_id,
						  'action'		=> $type==2?'complete':'uncomplete',
						  'content'		=> $task->task,
						  'url'			=> "/p/{$this->data['project']->alias}/tasks/comments/{$task->task_id}");
						
			//send email
			$users = $this->projects_model->get_project_users($this->data['project']->project_id, '', TRUE);
			if($users)
			{
				$emails = array();
				
				foreach($users as $row)
				{
					if($row->user_id != $this->auth->get_user_id())
						$emails[] = $row->email;
				}				
				
				$logg['to'] = $emails;
				
				$email = 'Task_marked_as_complete';
			}			
			//log
			$this->events->log($logg, $email);	
			
			$return['code'] =  202;
			$return['msg'] = 'The task is marked '.($type==2?'complete':'uncomplete').' successfully.';
		}
		
		$this->output->set_content_type('application/json')
    				 ->set_output(json_encode($return));
		
	}
	
	public function add_list()
	{
		$this->form_validation->set_rules($this->validation_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("user_id"		=> $this->auth->get_user_id(),
							"project_id"	=> $this->data['project']->project_id,
							"title"			=> $this->input->post("title"),
							"description"	=> $this->input->post("description"),							
							"status" 		=> 1,
							"created" 		=> date('Y-m-d H:i:s'));
			
			$list_id = $this->tasks_model->create_list($fields);
			
			$this->session->set_flashdata("msg", "Task list successfully created");
			
			redirect("/p/{$this->data['project']->alias}/tasks/");
		}
		else 
		{
			$this->template->load('tasks/add_list', $this->data);
		}
	}
	
	public function comment_delete($comment_id)
	{
		$comment = $this->tasks_model->get_comment($comment_id);
		
		if(empty($comment))
		{
			$this->session->set_flashdata('msg', 'Comment was not found!');	
			redirect("/p/{$this->data['project']->alias}/tasks/");
		}
		
		$this->tasks_model->delete_comment($comment->comment_id);
			
		$this->session->set_flashdata("msg", "Comment successfully deleted!");
			
		redirect("/p/{$this->data['project']->alias}/tasks/comments/{$comment->task_id}");
	}
}
 
/* End of file  tasks.php */