<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Projects extends MY_Controller 
{
	public $data = array();
	
	private $validation_rules = array(
		array(
			'field' => 'title',
			'label' => 'Project Title',
			'rules' => 'trim|required'
		),
		array(
			'field' => 'description',
			'label' => 'Project Description',
			'rules' => 'trim|'
		)
	);
	
	private $users_rules = array(
		array(
			'field' => 'user',
			'label' => 'User',
			'rules' => 'trim|required'
		)
	);

	public function __construct()
	{
		parent::__construct();
		
		
		
		$this->load->model('projects_model');
	}
	
	public function index()
	{		
		//allow only admin
		$this->auth->restrict_admin();		
		
		$this->load->library('pagination');
		
		$this->data['total'] = $this->projects_model->get_total_projects();

		$config['base_url'] = site_url("projects/index");
		$config['total_rows'] = $this->data['total'];
		$config['per_page'] = 20;
		$config['uri_segment'] = 3;
		
		$this->pagination->initialize($config);
		
		$this->data['pagination'] = $this->pagination->create_links();

		$this->data['projects'] = $this->projects_model->get_all_projects($config['per_page'],$this->uri->segment($config['uri_segment']));		
		
		$this->template->load('projects/index', $this->data);
	}
	
	public function create()
	{
		$this->form_validation->set_rules($this->validation_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("user_id"		=> $this->auth->get_user_id(),
							"title"			=> $this->input->post("title"),
							"alias"			=> url_title($this->input->post("title"),'-', TRUE),
							"description"	=> $this->input->post("description"),							
							"status" 		=> 1,
							"created" 		=> date('Y-m-d H:i:s'));
			
			$project_id = $this->projects_model->create_project($fields);
			
			$this->session->set_flashdata("msg", "Project successfully created");
			
			if($this->auth->is_client())
			{
				$fields = array("project_id"	=> $project_id,
								"user_id"		=> $this->auth->get_user_id());
				$this->projects_model->create_project_user($fields);
				
				$fields = array("project_id"	=> $project_id,
								"user_id"		=> 1);
				$this->projects_model->create_project_user($fields);
				
				redirect('/');
				exit;
			}
						
			redirect('projects');
			
		}
		else 
		{
			$this->template->load('projects/create', $this->data);
		}
	}
	
	public function edit($id)
	{		
		$project = $this->projects_model->get_project($id);
		
		if(empty($project))
		{
			$this->session->set_flashdata('msg', 'Project not found!');	
			
			redirect('projects');
		}
		
		$this->form_validation->set_rules($this->validation_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("title"			=> $this->input->post("title"),
							"description"	=> $this->input->post("description"),
							"status" 		=> $this->input->post("status"));
			
			$this->projects_model->update_project($project->project_id, $fields);
			
			$this->session->set_flashdata("msg", "Project successfully updated");
			
			if($this->auth->is_client())
			{
				redirect('/');
				exit;
			}
			
			redirect('projects');
		}
		else 
		{
			$this->data['project'] = $project;

			$this->template->load('projects/edit', $this->data);
		}
	}
	
	public function view($id)
	{		
		//allow only admin
		$this->auth->restrict_admin();		
		
		$project = $this->projects_model->get_project($id);
		if(empty($project))
		{
			$this->session->set_flashdata('msg', 'Project not found!');	
			redirect('projects');
		}
		
		$this->data['project'] = $project;
		
		$this->template->load('projects/view', $this->data);
	}
	
	public function users($id)
	{
		//allow only admin
		$this->auth->restrict_admin();		
		
		$project = $this->projects_model->get_project($id);
		
		if(empty($project))
		{
			$this->session->set_flashdata('msg', 'Project not found!');	
			redirect('projects');
		}
		
		$this->data['proj'] = $project;
		
		$this->data['clients'] = $this->projects_model->get_project_users($id, 1);

		$this->data['users'] = $this->projects_model->get_project_users($id, 2);		
		
		$this->template->load('projects/users', $this->data);
	}
	
	public function user_add($id)
	{
		//allow only admin
		$this->auth->restrict_admin();		
		
		$project = $this->projects_model->get_project($id);
		
		if(empty($project))
		{
			$this->session->set_flashdata('msg', 'Project not found!');	
			redirect('projects');
		}
		
		$this->form_validation->set_rules($this->users_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("project_id"	=> $project->project_id,
							"user_id"		=> $this->input->post("user"));
			
			$project_id = $this->projects_model->create_project_user($fields);
			
			$this->session->set_flashdata("msg", "Project user successfully created");
			
			redirect('projects/users/'.$project->project_id);
		}
		else 
		{
			$this->data['proj'] = $project;
		
			$this->data['users'] = $this->auth_model->get_users_group($id, 2);
			
			$this->template->load('projects/user_add', $this->data);
		}		
	}
	
	public function user_delete($id, $user_id)
	{
		//allow only admin
		$this->auth->restrict_admin();		
		
		$project = $this->projects_model->get_project($id);
		
		if(empty($project))
		{
			$this->session->set_flashdata('msg', 'Project not found!');	
			redirect('projects');
		}
				
		if($this->projects_model->get_user_project($user_id,$id))
		{
			$this->projects_model->delete_project_user($id, $user_id);
			
			$this->session->set_flashdata('msg', 'Project user successfully deleted!');	
			redirect('projects/users/'.$id);
		}
		else 
		{
			$this->session->set_flashdata('msg', 'Project user was not found or user doesnt belong to this project!');	
			redirect('projects/users/'.$id);
		}
	}
	
	public function client_add($id)
	{
		//allow only admin
		$this->auth->restrict_admin();		
		
		$project = $this->projects_model->get_project($id);
		
		if(empty($project))
		{
			$this->session->set_flashdata('msg', 'Project not found!');	
			redirect('projects');
		}
		
		$this->form_validation->set_rules($this->users_rules);

		if ($this->form_validation->run($this) === TRUE)
		{
			$fields = array("project_id"	=> $project->project_id,
							"user_id"		=> $this->input->post("user"));
			
			$project_id = $this->projects_model->create_project_user($fields);
			
			$this->session->set_flashdata("msg", "Project client successfully created");
			
			redirect('projects/users/'.$project->project_id);
		}
		else 
		{
			$this->data['proj'] = $project;
		
			$this->data['users'] = $this->auth_model->get_users_group($id, 1);
			
			$this->template->load('projects/client_add', $this->data);
		}		
	}
	
}

/* End of file projects.php */
/* Location: ./application/controllers/projects.php */