<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users extends MY_Controller 
{
	public $data = array();
	
	private $validation_rules = array(	
		array(
			'field' => 'firstname',
			'label' => 'firstname',
			'rules' => 'trim|xss_clean'
		),
		array(
			'field' => 'lastname',
			'label' => 'lastname',
			'rules' => 'trim|xss_clean'
		),
		array(
			'field' => 'username',
			'label' => 'username',
			'rules' => 'trim|required|xss_clean|min_length[4]|max_length[20]|alpha_dash|callback__username_check',
		),
		array(
			'field' => 'email',
			'label' => 'email address',
			'rules' => 'trim|required|xss_clean|valid_email|callback__email_check'
		),
		array(
			'field' => 'aboutme',
			'label' => 'about me',
			'rules' => 'trim|xss_clean'
		),
		array(
			'field' => 'password', 
			'label' => 'password',
			'rules' => 'trim|required|xss_clean|min_length[4]|max_length[20]|matches[confirm_password]'
		),
		array(
			'field' => 'confirm_password',
			'label' => 'confirm password',
			'rules' => 'trim|xss_clean|min_length[4]|max_length[20]'
		)
	);
	
	public function __construct()
	{
		parent::__construct();
		
		$this->auth->restrict_admin();
	}
	
	public function index()
	{		
		$this->load->library('pagination');
		
		$this->data['total'] = $this->auth_model->get_total_users();

		$config['base_url'] = site_url("users/index");
		$config['total_rows'] = $this->data['total'];
		$config['per_page'] = 20;
		$config['uri_segment'] = 3;
		
		$this->pagination->initialize($config);
		
		$this->data['pagination'] = $this->pagination->create_links();

		$this->data['users'] = $this->auth_model->get_all_users($config['per_page'],$this->uri->segment($config['uri_segment']));		
		
		$this->template->load('users/index', $this->data);
	}
	
	public function create()
	{
		$this->form_validation->set_rules($this->validation_rules);

		if ($this->form_validation->run($this) === TRUE && $this->auth->register($this->input->post('username'), $this->input->post('password'), $this->input->post('email'), TRUE))
		{
			$this->session->set_flashdata("msg", "User successfully created.");
			
			redirect('users');
		}
		else 
		{
			$this->template->load('users/create', $this->data);
		}
	}
	
	public function edit($id)
	{
		$user = $this->auth_model->get_user($id);
		if(empty($user))
		{
			$this->session->set_flashdata('msg', 'User not found!');	
			redirect('users');
		}
		
		$this->validation_rules[2]['rules'] .= "[{$user->username}]";
		$this->validation_rules[3]['rules'] .= "[{$user->email}]";
		
		if(! $this->input->post('password'))
		{
			unset($this->validation_rules[5]);
			unset($this->validation_rules[6]);
		}
		
		$this->form_validation->set_rules($this->validation_rules);

		if ($this->form_validation->run($this) === TRUE)
		{			
			$fields = array();
			
			$fields['user'] = array('email' => $this->input->post('email'));
			
			if($this->input->post('password'))
			{
				$fields['user']['password'] = $this->input->post('password');
			}
			
			$fields['profile'] = array('firstname' => $this->input->post('firstname'),
									   'lastname' => $this->input->post('lastname'),
									   'aboutme' => $this->input->post('aboutme'));
			
			$this->auth->update_user($user->id, $fields);
			
			$this->session->set_flashdata("msg", "User successfully updated");
			
			redirect('users');
		}
		else 
		{
			$this->data['user'] = $user;

			$this->template->load('users/edit', $this->data);
		}
	}
	
	/* */
	
	public function _username_check($username, $old_username = FALSE)
	{
		if($old_username AND $old_username==$username)
		{
			return TRUE;
		}
		if(! preg_match("/^[A-Za-z][A-Za-z0-9]*(?:_[A-Za-z0-9]+)*$/", $username))
		{
			$this->form_validation->set_message('_username_check', 'Invalid username! Alphanumerics only.');
			
			return FALSE;
		}
		else if (! $result = $this->auth->is_username_available($username))
		{
			$this->form_validation->set_message('_username_check', 'This username is already taken!');
			
			return FALSE;
		}
				
		return TRUE;
	}
	
	public function _email_check($email, $old_email = FALSE)
	{
		if($old_email AND $old_email==$email)
		{
			return TRUE;
		}
		
		$result = $this->auth->is_email_available($email);
		
		if (! $result)
		{
			$this->form_validation->set_message('_email_check', 'Email Address is not available');
		}
		
		return $result;
	}
	
}

/* End of file developers.php */
/* Location: ./application/controllers/developers.php */