<?php
class MY_Controller extends CI_Controller
{
	public $data = array();
	
	public function __construct()
	{
		parent::__construct();
		
		$this->load->library('auth');
		
		$this->auth->restrict();	

		$this->data['active_url'] = $this->uri->segment(3);
	}
	
	public function project()
	{
		$this->load->model('projects_model');
		
		$project_id = $this->uri->segment(2);
		
		$user_id = $this->auth->get_user_id();
		
		$this->data['project'] = $this->projects_model->get_user_project($user_id, $project_id);
		
		if(! $this->data['project'])
		{
			$this->session->Set_flashdata("msg", "You do not have access or project does not exist!");
			redirect('');
		}		
		
	}
	
}