<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Auth
{
	protected $ci;
	protected $settings;
	public $_auth_error;
	
	public function __construct()
	{
		$this->ci =& get_instance();
		
		$this->settings = config_item('settings');
	
		$this->ci->load->helper('cookie');		
		$this->ci->load->model('auth_model');			
				
		$this->init();
	}
	
	private function init()
	{
		$this->allow_registration 	= $this->settings['allow_registration'];
		$this->captcha_registration = $this->settings['captcha_registration'];
		$this->email_activation 	= $this->settings['email_activation'];
		$this->email_account_details= $this->settings['email_account_details'];
		
		$this->min_username = 4;
		$this->max_username = 20;
		$this->min_password = 6;
		$this->max_password = 20;
	}
	
	public function login($login, $password, $remember = FALSE)
	{
		if($this->settings['username_login'] && $this->settings['email_login'])
		{
			$login_function = "get_user_login";
		}
		elseif($this->settings['email_login'])
		{
			$login_function = "get_user_login_by_email";
		}
		else
		{
			$login_function = "get_user_login_by_username";
		}
		
		if($result = $this->ci->auth_model->$login_function($login, $password))
		{
			
			if($result->active==0)
			{
				$this->_auth_error = 'Your account has been suspended.';
				return FALSE;
			}
			
			if (!empty($result->activation_code))
			{
				$this->_auth_error = 'Please check your email to activate your account.';
				return FALSE;
			}
			
			
			if($result->failed_logins > $this->settings['max_login_attempt'])
			{			
					
				$now = time();
				$wait = $now - 20;
				
				if($result->last_failure > $wait)
				{
					$this->_auth_error = 'Too many attempts.  You can try again in 20 seconds.';
					return FALSE;
				}
			}
			else 
			{
				
				if($this->encode($password) == $result->password)
				{
					
					if ($remember) 
					{
						$this->create_autologin($result->id);
					}
					
					$userdata = array("id"			=> $result->id,
									  "username" 	=> $result->username,
									  "logged_in"	=> TRUE,
									  "group_id"	=> $result->group_id);
					
					$this->ci->session->set_userdata($userdata);
					
					$this->ci->auth_model->reset_last_login($result->id);
					
					$this->_auth_error = '';
					return TRUE;
				}
				else 
				{
					$this->_auth_error = 'Incorrect username or password. Please try again.';		
					$this->ci->auth_model->increase_failed_logins($result->id, $result->failed_logins);
				}
			}
		}
		else
		{
			$this->_auth_error = 'Incorrect username or password.';	
		}
		return FALSE;
	}
	
	public function logout()
	{
		$this->delete_autologin();
		
		$this->ci->session->sess_destroy();	
	}
	
	public function register($username, $password, $email, $admin=false)
	{	
		$this->ci->load->helper('url');

		$result = FALSE;

		$new_user = array(	
			'group_id'		=> $this->settings['default_group'],
			'username'		=> strtolower($username),			
			'password'		=> $this->encode($password),
			'email'			=> $email,
			'created'		=> time(),
			'modified'		=> time(),
			'ip'			=> $this->ci->input->ip_address()
		);
		
		if($admin)
			$this->email_activation = FALSE;

		if ($this->email_activation)
		{
			// Add activation key to user array
			$new_user['active']		= -1;
			$new_user['activation_code'] = md5(rand().microtime());
		}	
		else
		{
			$new_user['active']		= 1;
			$new_user['activated']	= time();
		}

		$insert = $this->ci->auth_model->create_user($new_user);			
		
		if ($insert)
		{
			$fields = array('firstname' => $this->ci->input->post('firstname'),
							'lastname' => $this->ci->input->post('lastname'),
							'aboutme' => $this->ci->input->post('aboutme'));
			
			$this->ci->auth_model->create_profile($insert, $fields);
			
			$new_user['password'] = $password;
			
			$result = TRUE;
			
			if ($this->email_activation)
			{
				$new_user['activate_url'] = site_url('members/activate/'."{$new_user['username']}/{$new_user['activation_code']}");
				$new_user['firstname'] = $this->ci->input->post('firstname');
				$this->email($email, 'auth_activate', $new_user);
			}
			else
			{
				// Check if need to email account details						
				if ($this->email_account_details) 
				{
					$this->email($email, 'auth_account_details', $new_user);													
				}
			}
		}
		
		return $result;
	
	}
	
	function activate($username, $key = '')
	{		
		// Default return value
		$result = FALSE;
		$user = $this->ci->auth_model->get_activate_code($username, $key);			

		if(!empty($user))
		{
			$data['active'] = 1;
			$data['activation_code'] = '';
			$data['activated'] = time();
			
			$this->ci->auth_model->update_user($user->id, array('user' => $data));
			
			
			$result = TRUE;
		}

		return $result;
	}
	
	public function forgot_password($login)
	{
		$result = FALSE;
	
		if ($login)
		{
			$user = $this->ci->auth_model->get_user_login($login);
			
			if (!empty($user))
			{				
				if ($user->reset_code=="" && $user->reset_time < strtotime("-1 day"))
				{
					$data = array();
					
					$data['reset_code'] = md5(rand().microtime());
					$data['reset_time'] = time();
					
					$this->ci->auth_model->update_user($user->id, array('user'=>$data));

					// Create reset password link to be included in email
					$data['username'] = $user->username;
					$data['reset_password_uri'] = site_url('members/reset_password/'."{$user->username}/{$data['reset_code']}");

					$this->delete_autologin(); // clear all autologins
					
					$this->email($user->email, 'auth_reset', $data);
					
					$result = TRUE;
				}
				else
				{
					$this->_auth_error = "Email already sent with reset instructions.";
				}
			}
			else
			{
				$this->_auth_error = "Username or Email does not exist.";
			}
		}
		
		return $result;
	}
	
	public function reset_password($username, $password)
	{

		$result = FALSE;
		
		$user = $this->ci->auth_model->get_user_login_by_username($username);
		
		if(!empty($user))
		{
			$data['password'] = $this->encode($password);
			$data['modified'] = time();
			$data['reset_code'] = '';
			$data['reset_time'] = 0;
			$this->ci->auth_model->update_user($user->id, array('user'=>$data));
			
		//	$edata['password'] = $password;
		//	$edata['username'] = $user->username;
			
		//	$this->email($user->email, 'auth_new_details', $edata);
			
			$result = TRUE;
		}

		return $result;
	}
	
	public function update_user($user_id, $data)
	{
		if(isset($data['user']['password'])) $data['user']['password'] = $this->encode($data['user']['password']);
		
		$this->ci->auth_model->update_user($user_id, $data);
		
	}
	
	public function check_reset_password($username, $key = '')
	{
		return $this->ci->auth_model->check_reset_password($username, $key);
	}
		
	public function email($email, $template = 'default', $data = array())
	{
		$this->ci->load->library('Email');
		$config['protocol'] = $this->settings['mail_protocol'];
		$config['charset'] = 'utf-8';
		$config['wordwrap'] = TRUE;
		$config['mailtype'] = "html";
		
		$this->ci->email->initialize($config);
		
		$from = $this->settings['server_email'];
		$subject = $this->ci->lang->line("{$template}_subject");
		$data['title'] = $subject;
		$data['email'] = $email;
		$message = $this->ci->load->view("emails/{$template}", $data, TRUE);
		
		$this->ci->email->from($from, "Amerikaliturk.com");
		$this->ci->email->to($email);
		$this->ci->email->subject($subject);
		$this->ci->email->message($message);

		return $this->ci->email->send();
	}	
	
	public function get_user($id = FALSE)
	{
		$id = !$id ? $this->ci->session->userdata('id'): $id;
		return $this->ci->auth_model->get_user($id);
	}
	
	public function get_user_id()
	{
		return $this->ci->session->userdata('id');
	}
	
	public function get_username()
	{
		return $this->ci->session->userdata('username');
	}
	
	/*
	 * check if user logged in
	 */
	public function is_logged_in()
	{
		return $this->ci->session->userdata("logged_in");
	}
	
	public function is_admin()
	{
		return $this->ci->session->userdata("group_id") == 3;
	}
	
	public function is_client()
	{
		return $this->ci->session->userdata('group_id') == 1;
	}
	
	/*
	 * check whether max login attempts exceeded
	 */
	public function is_max_login_failed()
	{
		return $this->ci->auth_model->get_failed_logins_count($this->ci->input->ip_address()) > $this->settings['max_login_attempt']?TRUE:FALSE;
	}
	
	/*
	 * Check if username is available to use, by making sure there is no same username in the database
	 * return true if one exists
	 */
	public function is_username_available($username)
	{
		return $this->ci->auth_model->check_username($username);
	}
	
	/*
	 * Check if email is available to use, by making sure there is no same email in the database
	 * return true if one exists
	 */
	function is_email_available($email, $update = false)
	{
		if($update) $id = $this->get_user_id();
		else $id = false;
		return $this->ci->auth_model->check_email($email, $id);
	}		

	public function restrict($user_group = FALSE)
	{
		if($user_group == 'logged_out')
		{
			if ($this->is_logged_in())
			{
				redirect('/');
			}
		}
		else if( ! $this->is_logged_in())
		{
			if($this->ci->uri->uri_string()!='')
			{
				$this->ci->session->set_flashdata('msg', 'Please login first.');
			}
			$this->ci->session->set_flashdata('referrer', $this->ci->uri->uri_string());
			redirect('/login');
		}
		else if ($user_group AND $this->get_user()->group_id !== $user_group)
		{
			$this->ci->session->set_flashdata('referrer', $this->ci->uri->uri_string());
			redirect('/login');
		}
	}
	
	public function restrict_admin()
	{
		if(! $this->is_admin() )
		{
			$this->ci->session->set_flashdata('msg', 'You do not have access to this page!');
			redirect('/');
		}
	}
	
	/* --------------------------------------------- ---------------------------------------------
	 * ----------------------------------         -   -         ----------------------------------         
	 * ------------------------                   -   -                   ------------------------          
	 * ----------------------------------         - - -         ----------------------------------
	 * ---------------------------------------------  --------------------------------------------
	 */
	
	/* 
	 * autologin
	 *  
	 */
	private function create_autologin($user_id)
	{
		
		$key = substr(md5(uniqid(rand().$this->settings['cookie_name'])), 0, 16);
		
		$this->ci->auth_model->purge_autologin($user_id);

		if ($this->ci->auth_model->set_autologin($user_id, md5($key))) 
		{
			set_cookie($this->settings['cookie_name'],serialize(array('user_id' => $user_id, 'key' => $key)),$this->settings['cookie_life']);
			
			return TRUE;
		}
		return FALSE;
	}

	/**
	 * Clear user's autologin data
	 *
	 * @return	void
	 */
	private function delete_autologin()
	{
		
		if ($cookie = get_cookie($this->settings['cookie_name'], TRUE)) {

			$data = unserialize($cookie);

			$this->ci->auth_model->delete_autologin($data['user_id'], md5($data['key']));

			delete_cookie($this->settings['cookie_name']);
		}
	}

	/**
	 * Login user automatically if he/she provides correct autologin verification
	 *
	 * @return	void
	 */
	private function autologin()
	{
		if (!$this->is_logged_in()) {			// not logged in (as any user)

			if ($cookie = get_cookie($this->settings['cookie_name'], TRUE)) {

				$data = unserialize($cookie);

				if (isset($data['key']) AND isset($data['user_id'])) {

					
					if (!is_null($user = $this->ci->auth_model->get_autologin($data['user_id'], md5($data['key'])))) {

						// Login user
						
						$userdata = array("id"			=> $user->id,
									  "username" 	=> $user->username,
									  "logged_in"	=> TRUE);
					
						$this->ci->session->set_userdata($userdata);
						
						// Renew users cookie to prevent it from expiring
						set_cookie($this->settings['cookie_name'],$cookie,$this->settings['cookie_life']);

						$this->ci->auth_model->reset_last_login($user->id);
						
						return TRUE;
					}
				}
			}
		}
		return FALSE;
	}
	
	
	/*
	 * get auth errors
	 */
	public function get_auth_errors()
	{
		return $this->_auth_error;
	}
	
	/* 
	 * encode password 
	 */
	public function encode($string)
	{
		$majorsalt = $this->settings['hash'];
		
		if (function_exists('str_split'))
		{
			$_pass = str_split($string);
		}
		else
		{
			$_pass = array();
			if (is_string($password))
			{
				for ($i = 0; $i < strlen($password); $i++)
				{
					array_push($_pass, $password[$i]);
				}
			}
		}
	
		foreach ($_pass as $_hashpass)
		{
			$majorsalt .= md5($_hashpass);
		}

		return md5($majorsalt);
	}
	
}