<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Project name
 *
 * File description
 *
 * @author		Ulugbek D.
 * @since		Version 1.0
 * @filesource
 */

class Events
{
	public $_ci;
	
	public function __construct()
	{
		$this->_ci =& get_instance();		
		
		$this->_ci->load->model('events_model');
	}
	
	public function get_logs($project)
	{
		$data['logs'] = $this->_ci->events_model->get_project_logs($project);
		
		return $this->_ci->load->view('pages/events/list', $data, TRUE);
	}
	
	public function log($fields, $email = FALSE)
	{
		$data = array('user_id' => $this->_ci->auth->get_user_id(),
					  'time'	=> date('Y-m-d H:i:s'));
		
		$data['project_id'] = $fields['project']->project_id;
		$data['type'] = $fields['type'];
		$data['type_id'] = $fields['type_id'];
		$data['action'] = $fields['action'];
		$data['content'] = $fields['content'];
		$data['url'] = $fields['url'];

		$this->_ci->events_model->add_event($data);
		
		if($email)
		{
			$this->send_email($email, $fields);
		}
	}
	
	public function send_email($template, $data)
	{
		$data['username'] = $this->_ci->auth->get_username();
		
		$this->_ci->email->send_email($template, $data);
	}
}
 
/* End of file  Events.php */