<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * COMMONIR
 *
 * Email class
 *
 * @author		Ulugbek D.
 * @since		Version 1.0
 * @filesource
 */
 
class MY_Email extends CI_Email
{
	private $_settings;
	
	private static $_templates = array();
	
	/*
	 * Construct
	 */
	
	public function __construct($config = array())
	{
		parent::__construct($config);
		
		$this->_ci =& get_instance();
		
		$this->_settings = $this->_ci->config->item("email");
		
		$config['protocol'] = $this->_settings['protocol'];
		$config['mailtype']	= 'html';
        $config['charset']	= 'utf-8';
        $config['crlf']		= '\r\n';
        $config['newline']	= '\r\n';
        
        //sendmail options
        if ($this->_settings['protocol'] == 'sendmail')
        {
                if($this->_settings['mailpath'] == '')
                {
                        //set a default
                        $config['mailpath'] = '/usr/sbin/sendmail';
                }
                else
                {
                        $config['mailpath'] = $this->_settings['mailpath'];
                }
        }
        
        //smtp options
        if ($this->_settings['protocol'] == 'smtp')
        {
                $config['smtp_host'] = $this->_settings['smtp_host'];
                $config['smtp_user'] = $this->_settings['smtp_user'];
                $config['smtp_pass'] = $this->_settings['smtp_pass'];
                $config['smtp_port'] = $this->_settings['smtp_port'];
        }
        
        //initialiaze email library
		$this->initialize($config);
		
		//get templates
		//$this->get_templates();
		
	}
	
	// --------------------------------------------------------------------
	
	/*
	 * Send email
	 *
	 * @access	public
	 * @param	array
	 * @return	bool
	 */	
	public function send_email($alias, $data = array())
	{	
		$data['site_name'] = $this->_ci->config->item("site_name");	
		$to		  = isset($data['to']) ? $data['to'] : $this->_settings['webmaster_email'];
			        	
	    $name 	  = isset($data['name']) ? $data['name'] : $this->_settings['from_name'];
		$from	  = isset($data['from']) ? $data['from'] : $this->_settings['from_email'];
		$reply_to = isset($data['reply-to']) ? $data['reply-to'] : $from;
		
		$subject = str_replace('_',' ', $alias);
	
		$body = $this->_ci->load->view('email/'.$alias, $data, TRUE);
			
		if(!is_array($to))
		{
			$to[] = array($to); 
		}
		
		foreach($to as $row)
		{
	        $this->_ci->email->clear();
	        	
			$this->_ci->email->from($from, $name);
	        $this->_ci->email->reply_to($reply_to);
	        $this->_ci->email->to($row);
	        $this->_ci->email->subject($subject);
	        $this->_ci->email->message($body);
	
			$this->_ci->email->send();
		}
		
	}
	
}
 
 
/* End of file  Email.php */