<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Template
{
	protected $_head = array();
	protected $ci;
	protected $setting_list = array();
	
	public $breadcrumbs = array(array('name'=>"Home", 'uri'=>'/'));
	
	public function __construct()
	{
		$this->ci =& get_instance();

		$this->setting_list = config_item('settings');
		
		$this->metas();
		
		$this->ci->output->enable_profiler(FALSE);
		
		$this->generate_breadcrumb();
	}
	
	public function set_defaults($var, $val = "")
	{
		if(is_array($var))
		{
			foreach($var as $v=>$l)
			{
				$this->setting_list[$v] = $l;	
			}
		}
		else 
		{
			$this->setting_list[$var] = $val;	
		}
	}
	
	
	public function metas($metas = array(), $value = '')
	{
		
		if( ! is_array($metas))
		{
			$metas = array($metas => $value);
		}
		
		if(isset($metas['title'])) $metas['meta_title'] = $metas['title'];
		unset($metas['title']);
		
		// Get default metas from the config file
		$default_metas = array(
								'meta_title' => $this->setting_list['website_name'],
								'meta_description' 	=> $this->setting_list['meta_description'],
								'meta_keywords' 	=> $this->setting_list['meta_keywords']
							  );
		
		if(isset($metas['meta_title'])) $metas['meta_title'] .= ' - '.$this->setting_list['website_name'];
										
		// Overwrite default metas where possible
		$metas = array_merge($default_metas, $metas);

		$this->ci->load->vars($metas);
		return $metas;
	}
	
	public function append_head($line)
	{
		$this->_head[] = $line;
	}
	
	public function load($page, $data = array(), $direct = FALSE)
	{
		if(!is_array($data)) $data = (array) $data;
		
		if(isset($data['nocache']))
		{
			$this->ci->output->set_header("Cache-Control: no-cache, must-revalidate");
			$this->ci->output->set_header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
			$this->ci->output->set_header("Content-Type: text/html; charset=UTF-8");
		}
		
		$data['page'] = $page;
		
		$data['settings'] = $this->setting_list;
		
		$data['metadata']= implode("\n\t\t", $this->_head);
		
		$data['breadcrumbs'] = $this->breadcrumbs;
		
		if ($this->ci->input->is_ajax_request())
		{
			exit($this->ci->load->view("pages/$page", $data, TRUE));
		}		
		
		if($direct)
		{
			$this->ci->load->view("pages/$page", $data);
		}
		else
		{
			$this->ci->load->view('layout/container', $data);
		}	
	}	
	
	
	public function load_view($view = FALSE, $data = array(), $expires = 300)
	{
		//@TODO create config for enabled cache and cache time
		
		//$module = $this->ci->router->fetch_module();
		$cached_view = str_replace("/","_",$view);
		
		$this->ci->load->driver('cache', array('adapter' => 'file'));

		if ( ! $content = $this->ci->cache->get($cached_view))
		{
		     $content = $this->ci->load->view($view,$data,TRUE);
		
		     // Save into the cache for 5 minutes
		     $this->ci->cache->save($cached_view, $content, $expires);
		}
		
		echo $content; 
	}	
	
	public function set_breadcrumb($name, $uri = '')
	{
		$this->breadcrumbs[] = array('name' => $name, 'uri' => $uri );
	}
	
	public function generate_breadcrumb()
	{		
		$segments = $this->ci->uri->segment_array();
		$uri = '';
		if($segments)
		{			
			foreach($segments as $segment)
			{				
				$uri .= $segment.'/';
				if(! preg_match('/(p|[0-9])/is', $segment))
				{
					$this->breadcrumbs[] = array('name' => ucfirst($segment), 'uri' => $uri);
				}				
			}
		}		
	}
	
}