-- phpMyAdmin SQL Dump
-- version 3.4.3.2
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Oct 18, 2012 at 10:38 PM
-- Server version: 5.1.40
-- PHP Version: 5.3.3

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

--
-- Database: `crm`
--

-- --------------------------------------------------------

--
-- Table structure for table `groups`
--

CREATE TABLE IF NOT EXISTS `groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL,
  `description` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `groups`
--

INSERT INTO `groups` (`id`, `title`, `alias`, `description`) VALUES
(1, 'Clients', 'clients', ''),
(2, 'Developers', 'developers', ''),
(3, 'Administrator', 'admin', '');

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE IF NOT EXISTS `notifications` (
  `notification_id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `project_id` (`project_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=cp1251 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `notifications`
--

INSERT INTO `notifications` (`notification_id`, `project_id`, `title`, `email`, `time`, `status`) VALUES
(1, 7, 'First Notification', '', '2012-07-18 00:45:00', 1),
(2, 4, 'Cornerstone Due Date', 'info@vunamarketing.com', '2012-07-20 08:00:00', 1);

-- --------------------------------------------------------

--
-- Table structure for table `projects`
--

CREATE TABLE IF NOT EXISTS `projects` (
  `project_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `title` varchar(250) NOT NULL,
  `description` text NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`project_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=cp1251 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `projects`
--

INSERT INTO `projects` (`project_id`, `user_id`, `title`, `description`, `status`, `created`) VALUES
(1, 1, 'BoardVote', '', 1, '2012-10-18 20:24:39');

-- --------------------------------------------------------

--
-- Table structure for table `project_users`
--

CREATE TABLE IF NOT EXISTS `project_users` (
  `project_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`project_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=cp1251;

--
-- Dumping data for table `project_users`
--

INSERT INTO `project_users` (`project_id`, `user_id`) VALUES
(1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `tasks`
--

CREATE TABLE IF NOT EXISTS `tasks` (
  `task_id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `task` text NOT NULL,
  `due_date` date NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`task_id`),
  KEY `project_id` (`project_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `timeline`
--

CREATE TABLE IF NOT EXISTS `timeline` (
  `timeline_id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `developer_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  PRIMARY KEY (`timeline_id`),
  KEY `project_id` (`project_id`,`developer_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=cp1251 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `timeline`
--

INSERT INTO `timeline` (`timeline_id`, `project_id`, `developer_id`, `start_date`, `end_date`) VALUES
(1, 1, 2, '2012-06-21', '2012-07-05'),
(2, 2, 1, '2012-07-02', '2012-08-04'),
(3, 3, 5, '2012-07-10', '2012-07-13'),
(4, 4, 6, '2012-07-06', '2012-07-20'),
(5, 5, 2, '2012-06-26', '2012-06-28'),
(6, 6, 2, '2012-06-28', '2012-06-30'),
(7, 7, 4, '2012-07-16', '2012-07-25'),
(8, 8, 4, '2012-07-19', '2012-07-23'),
(9, 9, 0, '2012-07-24', '2012-07-25'),
(10, 10, 5, '2012-07-27', '2012-07-29'),
(11, 11, 5, '2012-07-27', '2012-07-27'),
(12, 12, 4, '2012-07-30', '2012-07-31'),
(13, 13, 5, '2012-07-30', '2012-07-31');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `username` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `created` int(11) NOT NULL,
  `modified` int(11) NOT NULL,
  `last_login` int(11) NOT NULL,
  `ip` varchar(32) NOT NULL,
  `failed_logins` int(11) NOT NULL,
  `last_failure` int(11) NOT NULL,
  `active` int(1) NOT NULL,
  `activation_code` varchar(32) NOT NULL,
  `activated` int(11) NOT NULL,
  `reset_code` varchar(32) NOT NULL,
  `reset_time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_group_id` (`group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `group_id`, `username`, `email`, `password`, `created`, `modified`, `last_login`, `ip`, `failed_logins`, `last_failure`, `active`, `activation_code`, `activated`, `reset_code`, `reset_time`) VALUES
(1, 3, 'admin', 'xickan@yahoo.com', '60a764d9e46e914c701fe3eebca03a99', 1322674368, 1322674368, 1350576002, '127.0.0.1', 0, 0, 1, '', 1, '', 0),
(3, 2, 'xickan', 'xickan@gmail.com', '60a764d9e46e914c701fe3eebca03a99', 1322677251, 1322677251, 1350585232, '127.0.0.1', 0, 0, 1, '', 1, '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `users_autologin`
--

CREATE TABLE IF NOT EXISTS `users_autologin` (
  `key_id` char(32) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `user_agent` varchar(150) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `last_ip` varchar(40) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `last_login` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`key_id`,`user_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `users_profile`
--

CREATE TABLE IF NOT EXISTS `users_profile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `aboutme` text NOT NULL,
  `dob` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `users_profile`
--

INSERT INTO `users_profile` (`id`, `user_id`, `firstname`, `lastname`, `aboutme`, `dob`) VALUES
(1, 1, 'Josh', 'Krajick', '', '0000-00-00 00:00:00'),
(2, 3, 'Ulugbek', '', '', '0000-00-00 00:00:00');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `FK_group_id` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `users_autologin`
--
ALTER TABLE `users_autologin`
  ADD CONSTRAINT `users_autologin_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `users_profile`
--
ALTER TABLE `users_profile`
  ADD CONSTRAINT `FK_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
  
-----------------------------------------------------
  
CREATE TABLE IF NOT EXISTS `task_lists` (
  `list_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

ALTER TABLE `task_lists` ADD `user_id` INT NOT NULL AFTER `list_id`  ;

ALTER TABLE `task_lists` ADD `project_id` INT NOT NULL AFTER `list_id`;

ALTER TABLE `tasks` ADD `list_id` INT NOT NULL AFTER `task_id`;

ALTER TABLE `tasks` ADD `created` DATETIME NOT NULL;

ALTER TABLE `tasks` CHANGE `due_date` `due_date` DATE NULL ;
  
  
  
11/08/2012
ALTER TABLE `projects` ADD `alias` VARCHAR( 64 ) NOT NULL AFTER `title` ,
ADD UNIQUE (
`alias`
)  

ALTER TABLE `tasks` ADD `priority` INT( 1 ) NOT NULL AFTER `due_date` 
  

11/27/2012
ALTER TABLE `tasks` ADD `completed_time` DATETIME NULL ,
ADD `completed_by` INT NULL;

CREATE TABLE `crm`.`task_comments` (
`comment_id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`task_id` INT NOT NULL ,
`user_id` INT NOT NULL ,
`comment` TEXT NOT NULL ,
`created` DATETIME NOT NULL ,
`status` TINYINT( 1 ) NOT NULL ,
INDEX ( `task_id` , `user_id` )
) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci;

ALTER TABLE `task_comments` ADD FOREIGN KEY ( `task_id` ) REFERENCES `crm`.`tasks` (
`task_id`
) ON DELETE CASCADE ON UPDATE CASCADE ;

ALTER TABLE `task_comments` ADD FOREIGN KEY ( `user_id` ) REFERENCES `crm`.`users` (
`id`   ;
  
  
  
  
