<?php   if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Auth_model extends CI_Model
{
	protected $_user_table 			= "users";
	protected $_profile_table 		= "users_profile";
	protected $_user_perm_table 	= "users_permissions";
	protected $_autologin_table 	= "users_autologin";
	protected $_roles_table 		= "groups";
	protected $_roles_perms_table 	= "groups_permissions";
	protected $_perms_table 		= "permissions";
	
	protected $_project_users 		= "project_users";
	
	public function __construct()
	{
		parent::__construct();
	}
	
	public function get_all_users($limit = 0, $offset = 0)
	{
		$this->db->select("{$this->_user_table}.*, {$this->_profile_table}.firstname, {$this->_profile_table}.lastname, {$this->_roles_table}.title as group_name");
		$this->db->join($this->_profile_table, "{$this->_profile_table}.user_id = {$this->_user_table}.id");
		$this->db->join($this->_roles_table, "{$this->_roles_table}.id = {$this->_user_table}.group_id");
		$this->db->order_by("{$this->_user_table}.group_id DESC, id DESC");
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		$query = $this->db->get($this->_user_table);
		return $query->result();
	}
	
	public function get_total_users()
	{
		$query = $this->db->get($this->_user_table);
		return $query->num_rows();
	}
	
	public function get_users_group($project_id,$group_id,$limit = 0, $offset = 0)
	{
		$this->db->select("{$this->_user_table}.*, {$this->_profile_table}.firstname, {$this->_profile_table}.lastname");
		$this->db->join($this->_profile_table, "{$this->_profile_table}.user_id = {$this->_user_table}.id");
		
		$this->db->join($this->_project_users, "{$this->_project_users}.user_id = {$this->_user_table}.id", "LEFT");
		
		$this->db->where("{$this->_user_table}.group_id", $group_id);
		//$this->db->where("{$this->_project_users}.project_id", $project_id);
		
		//$this->db->where("{$this->_project_users}.user_id IS NULL");
		
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		$this->db->group_by("{$this->_user_table}.id");	
		
		$query = $this->db->get($this->_user_table);
		return $query->result();
	}
	
	public function get_users_query($q)
	{
		$this->db->select('id, username');
		$this->db->like('username', $q);
		$this->db->where('id <>', $this->auth->get_user_id());
		$query = $this->db->get($this->_user_table);
		return $query->result();
	}
	
	public function get_user($id)
	{
		$this->db->select("{$this->_user_table}.*, {$this->_profile_table}.firstname, {$this->_profile_table}.lastname, {$this->_profile_table}.aboutme, {$this->_roles_table}.title as group_name");
		$this->db->join($this->_profile_table, "{$this->_profile_table}.user_id = {$this->_user_table}.id");
		$this->db->join($this->_roles_table, "{$this->_roles_table}.id = {$this->_user_table}.group_id");
		$this->db->where("{$this->_user_table}.id", $id);
		$query = $this->db->get($this->_user_table);
		return $query->row();
	}
	
	public function get_user_login($login)
	{
		$this->db->where('username', $login);
		$this->db->or_where('email', $login);
		$query = $this->db->get($this->_user_table);
		return $query->row();
	}
	
	public function get_user_login_by_email($email)
	{
		$this->db->where('email', $email);
		$query = $this->db->get($this->_user_table);
		return $query->row();
	}
	
	public function get_user_login_by_username($login)
	{
		$this->db->where('username', $login);
		$query = $this->db->get($this->_user_table);
		return $query->row();
	}
	
	public function get_failed_logins_count($ip)
	{
		$this->db->where('ip', $ip);
		$this->db->where('failed_logins >', '0');
		$query = $this->db->get($this->_user_table);
		return $query->num_rows();
	}
	
	public function get_activate_code($username, $code)
	{
		$this->db->where(array('username' => $username, 'activation_code' => $code));
		$query = $this->db->get($this->_user_table);
		return $query->row();
	}
	
	public function check_username($username)
	{
		$this->db->where('LOWER(username)=', strtolower($username));
		$query = $this->db->get($this->_user_table);
		return $query->num_rows()>0?FALSE:TRUE;
	}

	public function check_email($email, $id)
	{
		if($id) $this->db->where('id <>', $id); 
		$this->db->where('LOWER(email)=', strtolower($email));
		$query = $this->db->get($this->_user_table);
		return $query->num_rows()>0?FALSE:TRUE;
	}
	
	public function check_reset_password($username, $code)
	{
		$this->db->where(array('username' => $username, 'reset_code' => $code, 'reset_time >' => strtotime('-1 day')));
		$query = $this->db->get($this->_user_table);
		return $query->num_rows()>0?TRUE:FALSE;
	}
	
	public function increase_failed_logins($id, $fails)
	{
		$this->db->where('id', $id);
		
		if($fails < 4)
		{
			$this->db->set('failed_logins', 'failed_logins + 1', FALSE);
		}
		
		$this->db->set('last_failure', time());
		$this->db->update($this->_user_table);
	}
	
	public function reset_last_login($id)
	{
		$fields = array("last_login"	=> time(),
						"ip"			=> $this->input->ip_address(),
						"failed_logins"	=> "0",
						"last_failure"	=> "0");
		
		$this->db->where('id', $id);				
		$this->db->set($fields);
		$this->db->update($this->_user_table);
	}
	
	public function create_user($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_user_table);
		
		$id = $this->db->insert_id();		
		return $id;
	}
	
	public function update_user($id, $data)
	{
		$this->db->set($data['user']);
		$this->db->where("id", $id);
		$this->db->update($this->_user_table);
		
		if(isset($data['profile']))
		{
			$this->update_profile($id, $data['profile']);
		}
	}
	
	public function delete_user($id)
	{
		$this->db->delete($this->_user_table,array('id'=>$id));
	}
	
	public function create_profile($id, $data = array())
	{
		$data['user_id'] = $id;
		$this->db->set($data);
		$this->db->insert($this->_profile_table);
	}
	
	public function update_profile($id, $data)
	{
		$this->db->set($data);
		$this->db->where("user_id", $id);
		$this->db->update($this->_profile_table);
	}
	
	
	/* groups */
	
	public function get_all_groups($limit = 0, $offset = 0)
	{
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		$query = $this->db->get($this->_roles_table);
		
		return $query->result();
	}
	
	public function get_total_groups()
	{
		$query = $this->db->get($this->_roles_table);
		return $query->num_rows();
	}
	
	public function get_group($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get($this->_roles_table);
		return $query->row();
	}
	
	public function create_group($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_roles_table);
	}
	
	public function update_group($id, $data)
	{
		$this->db->set($data);
		$this->db->where("user_id", $id);
		$this->db->update($this->_roles_table);
	}

	public function delete_group($id)
	{
		$this->db->delete($this->_roles_table, array('id'=>$id));
	}
	
	
	/*  permissions */

	public function get_all_permissions()
	{
		$query = $this->db->get($this->_perms_table);
		return $query->result();
	}
	
	
	public function get_group_permissions($group_id)
	{
		$this->db->select("{$this->_roles_perms_table}.*, {$this->_perms_table}.name, {$this->_perms_table}.module, {$this->_perms_table}.action");
		$this->db->join($this->_perms_table, "{$this->_perms_table}.id = {$this->_roles_perms_table}.permission_id");
		$this->db->where("{$this->_roles_perms_table}.group_id", $group_id);
		$query = $this->db->get($this->_roles_perms_table);

		$permissions = array();
		foreach($query->result() as $row)
		{
			$permissions[$row->module] = $row->action ? $row->action : TRUE;
		}
		
		return $permissions;
	}
	
	
	public function save_group_permission($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_roles_perms_table);
	}
	
}