<?php

class Crm_model extends CI_Model
{
	private $_notifications = 'notifications';
	private $_developers = 'developers';
	private $_projects = 'projects';
	private $_timeline = 'timeline';
	
	public function __construct()
	{
		parent::__construct();
	}
	
	public function get_current_projects($year, $month, $limit=0, $offset=0)
	{
		$this->db->select("{$this->_timeline}.*, {$this->_projects}.title, {$this->_projects}.style");
		$this->db->select("DAY({$this->_timeline}.start_date) as s_day");
		$this->db->select("DAY({$this->_timeline}.end_date) as e_day");
		$this->db->join($this->_projects, "{$this->_projects}.project_id = {$this->_timeline}.project_id", "LEFT");
		
		//$this->db->where("{$this->_timeline}.start_date>='{$year}-{$month}-01'", NULL, FALSE);
		//$this->db->where("{$this->_timeline}.end_date<='{$year}-{$month}-31'", NULL, FALSE);
		$this->db->where("YEAR({$this->_timeline}.start_date)={$year} AND MONTH({$this->_timeline}.start_date) = {$month}", NULL, FALSE);//(YEAR(startdt) = $year) AND (MONTH(startdt) = $month)
		$this->db->or_where("YEAR({$this->_timeline}.end_date)={$year} AND MONTH({$this->_timeline}.end_date) = {$month}", NULL, FALSE);

		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		$query = $this->db->get($this->_timeline);
		
		return $query->result();
	}
	
	public function create_timeline($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_timeline);
		
		return $this->db->insert_id();
	}
	
	public function update_timeline($id, $data)
	{
		$this->db->set($data);
		$this->db->where("timeline_id", $id);
		$this->db->update($this->_timeline);
	}
	
	
	
	/* */
	
	public function get_all_projects($limit = 0, $offset = 0)
	{
		$this->db->join($this->_timeline, "{$this->_projects}.project_id = {$this->_timeline}.project_id", "LEFT");
		
		$this->db->order_by("{$this->_timeline}.start_date DESC");
		
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		$query = $this->db->get($this->_projects);
		
		return $query->result();
	}
	
	public function get_todays_projects($date)
	{
		$this->db->join($this->_timeline, "{$this->_projects}.project_id = {$this->_timeline}.project_id", "LEFT");
		
		$this->db->where("{$this->_timeline}.start_date<='{$date}'", NULL, FALSE);
		$this->db->where("{$this->_timeline}.end_date>='{$date}'", NULL, FALSE);
				
		$query = $this->db->get($this->_projects);
		
		return $query->result();
	}
	
	public function get_total_projects()
	{
		return $this->db->count_all($this->_projects);
	}
	
	public function get_project($id)
	{
		$this->db->select("{$this->_projects}.*, {$this->_timeline}.*, {$this->_developers}.name as developer");
		
		$this->db->join($this->_timeline, "{$this->_projects}.project_id = {$this->_timeline}.project_id", "LEFT");
		$this->db->join($this->_developers, "{$this->_developers}.developer_id = {$this->_timeline}.developer_id", "LEFT");
		
		$this->db->where("{$this->_projects}.project_id", $id);
		$query = $this->db->get($this->_projects);
		return $query->row();
	}
	
	public function create_project($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_projects);
		
		return $this->db->insert_id();
	}
	
	public function update_project($id, $data)
	{
		$this->db->set($data);
		$this->db->where("project_id", $id);
		$this->db->update($this->_projects);
	}
	
	
	/* */
	
	public function get_all_developers($limit = 0, $offset = 0)
	{
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		
		$query = $this->db->get($this->_developers);
		
		return $query->result();
	}
	
	public function get_total_developers()
	{
		return $this->db->count_all($this->_developers);
	}
	
	public function get_developer($id)
	{
		$this->db->where("developer_id", $id);
		$query = $this->db->get($this->_developers);
		return $query->row();
	}
	
	public function create_developer($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_developers);
		
		return $this->db->insert_id();
	}
	
	public function update_developer($id, $data)
	{
		$this->db->set($data);
		$this->db->where("developer_id", $id);
		$this->db->update($this->_developers);
	}
} 


/* End of file crm_model.php */