<?php

class Events_model extends CI_Model
{
	private $_events = 'events';
	
	private $_projects = 'projects';
	
	private $_users = 'users';
	
	public function __construct()
	{
		parent::__construct();
	}
		
	public function get_project_logs($project_id, $limit = 0, $offset = 0)
	{
		$this->db->select("{$this->_events}.*, DATE({$this->_events}.time) as date, {$this->_projects}.title as project, {$this->_users}.username");
		
		$this->db->join($this->_projects, "{$this->_projects}.project_id = {$this->_events}.project_id", "LEFT");
		$this->db->join($this->_users, "{$this->_users}.id = {$this->_events}.user_id", "LEFT");
		
		$this->db->where("{$this->_events}.project_id", $project_id);
		
		$this->db->order_by("{$this->_events}.time DESC");
		
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		$query = $this->db->get($this->_events);
		
		return $query->result();
	}
	
	public function get_total_project_logs($project_id)
	{
		return $this->db->count_all($this->_events);
	}

	public function get_notification($id)
	{		
		$this->db->join($this->_projects, "{$this->_notifications}.project_id = {$this->_projects}.project_id");
		
		$this->db->where("{$this->_notifications}.project_id", $id);
		$query = $this->db->get($this->_notifications);
		return $query->row();
	}
	
	public function add_event($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_events);
		
		return $this->db->insert_id();
	}
	
	public function update_event($id, $data)
	{
		$this->db->set($data);
		$this->db->where("event_id", $id);
		$this->db->update($this->_events);
	}
	
	
} 


/* End of file crm_model.php */