<?php

class Files_model extends CI_Model
{
	private $_files = 'files';
	
	private $_projects = 'projects';
	
	private $_users = 'users';
	
	private $_comments = 'task_comments';
	
	public function __construct()
	{
		parent::__construct();
	}
		
	public function get_project_files($project_id, $limit = 0, $offset = 0)
	{
		$this->db->select("{$this->_files}.*, DATE({$this->_files}.created) as date, {$this->_projects}.title as project, {$this->_users}.username, {$this->_comments}.task_id, {$this->_comments}.comment");
		
		$this->db->join($this->_projects, "{$this->_projects}.project_id = {$this->_files}.project_id", "LEFT");
		$this->db->join($this->_users, "{$this->_users}.id = {$this->_files}.user_id", "LEFT");
		$this->db->join($this->_comments, "{$this->_comments}.comment_id = {$this->_files}.comment_id", "LEFT");
		
		$this->db->where("{$this->_files}.project_id", $project_id);
		
		$this->db->order_by("{$this->_files}.created DESC");
		
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		$query = $this->db->get($this->_files);
		
		return $query->result();
	}
	
	public function get_total_project_logs($project_id)
	{
		return $this->db->count_all($this->_events);
	}

	public function get_comment_files($comment_id)
	{		
		$this->db->where("{$this->_files}.comment_id", $comment_id);
		$query = $this->db->get($this->_files);
		return $query->result();
	}
	
	public function get_file($file_id)
	{		
		$this->db->where("{$this->_files}.file_id", $file_id);
		$query = $this->db->get($this->_files);
		return $query->row();
	}
	
	public function add_file($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_files);
		
		return $this->db->insert_id();
	}
	
	public function update_file($id, $data)
	{
		$this->db->set($data);
		$this->db->where("file_id", $id);
		$this->db->update($this->_files);
	}
	
	public function update_comment_file($ids, $data)
	{
		$this->db->set($data);
		$this->db->where_in("file_id", $ids);
		$this->db->update($this->_files);
	}
	
	public function delete_file($id)
	{		
		$this->db->delete($this->_files, array('file_id' => $id));
	}
	
} 


/* End of file crm_model.php */