<?php

class Notifications_model extends CI_Model
{
	private $_notifications = 'notifications';
	private $_developers = 'developers';
	private $_projects = 'projects';
	private $_timeline = 'timeline';
	
	public function __construct()
	{
		parent::__construct();
	}
		
	public function get_all_notifications($limit = 0, $offset = 0)
	{
		$this->db->join($this->_projects, "{$this->_projects}.project_id = {$this->_projects}.project_id", "LEFT");
		
		$this->db->order_by("{$this->_notifications}.start_date DESC");
		
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		$query = $this->db->get($this->_notifications);
		
		return $query->result();
	}
	
	public function get_total_notifications()
	{
		return $this->db->count_all($this->_notifications);
	}
	
	public function get_time_notifications()
	{
		$hour = date('Y-m-d H:i:s', strtotime("now"));
		$hour_plus = date('Y-m-d H:i:s', strtotime("+1 hours"));
		
		$this->db->select("{$this->_notifications}.*, {$this->_projects}.title as project");
		
		$this->db->join($this->_projects, "{$this->_projects}.project_id = {$this->_projects}.project_id");
		
		$this->db->where("{$this->_notifications}.time BETWEEN '{$hour}' AND '{$hour_plus}'", NULL, FALSE);
		$this->db->where("{$this->_notifications}.status", 0);
		
		$this->db->group_by("{$this->_notifications}.notification_id");

		$query = $this->db->get($this->_notifications);
		
		return $query->result();
	}
	
	
	public function get_notification($id)
	{
		
		$this->db->join($this->_projects, "{$this->_notifications}.project_id = {$this->_projects}.project_id");
		
		$this->db->where("{$this->_notifications}.project_id", $id);
		$query = $this->db->get($this->_notifications);
		return $query->row();
	}
	
	public function create_notification($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_notifications);
		
		return $this->db->insert_id();
	}
	
	public function update_notification($id, $data)
	{
		$this->db->set($data);
		$this->db->where("notification_id", $id);
		$this->db->update($this->_notifications);
	}
	
	
} 


/* End of file crm_model.php */