<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Project name
 *
 * File description
 *
 * @author		Ulugbek D.
 * @since		Version 1.0
 * @filesource
 */

class Projects_model extends CI_Model
{
	
	private $_projects = 'projects';
	
	private $_project_users = 'project_users';
	
	private $_events = 'events';
	
	private $_users = 'users';
	
	private $_profile = 'users_profile';
	
	public function __construct()
	{
		parent::__construct();
	}
		
	public function get_all_projects($limit = 0, $offset = 0)
	{
		$this->db->select("{$this->_projects}.*,{$this->_projects}.user_id as owner_id, {$this->_projects}.user_id");
		
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		
		$query = $this->db->get($this->_projects);
		
		return $query->result();
	}
	
	public function get_total_projects()
	{
		return $this->db->count_all($this->_projects);
	}
	
	public function get_project($id)
	{		
		$this->db->where("{$this->_projects}.project_id", $id);
		
		$query = $this->db->get($this->_projects);
		return $query->row();
	}
	
	public function get_user_project($user_id, $project_id)
	{
		$this->db->select("{$this->_projects}.*,{$this->_project_users}.user_id");
		$this->db->select_max("{$this->_events}.time");
		
		$this->db->join($this->_project_users, "{$this->_projects}.project_id = {$this->_project_users}.project_id", "LEFT");	
		$this->db->join($this->_events, "{$this->_events}.project_id = {$this->_project_users}.project_id", "LEFT");		
		
		if($user_id!=1)
		{
			$this->db->where("{$this->_project_users}.user_id", $user_id);
		}
		
		if(ctype_digit($project_id))
		{
			$this->db->where("{$this->_projects}.project_id", $project_id);
		}
		else
		{
			$this->db->where("{$this->_projects}.alias", $project_id);
		}
		
		$this->db->order_by("time DESC");	
		$this->db->group_by("{$this->_projects}.project_id");
		
		$query = $this->db->get($this->_projects);
		
		return $query->row();
	}
	
	public function get_user_projects($user_id)
	{		
		$this->db->select("{$this->_projects}.*,{$this->_projects}.user_id as owner_id, {$this->_project_users}.user_id");
		$this->db->select_max("{$this->_events}.time");
		
		$this->db->join($this->_projects, "{$this->_projects}.project_id = {$this->_project_users}.project_id");	
		$this->db->join($this->_events, "{$this->_events}.project_id = {$this->_project_users}.project_id", "LEFT");	
		
		$this->db->where("{$this->_project_users}.user_id", $user_id);
		
		$this->db->order_by("time DESC");	
		$this->db->group_by("{$this->_projects}.project_id");
		
		$query = $this->db->get($this->_project_users);
		
		return $query->result();
	}
	
	public function get_project_users($id, $group_id = 1, $nogroup = FALSE)
	{		
		$this->db->select("{$this->_projects}.*,{$this->_project_users}.user_id,{$this->_profile}.firstname,{$this->_profile}.lastname,{$this->_users}.username,{$this->_users}.email");
		
		$this->db->join($this->_projects, "{$this->_projects}.project_id = {$this->_project_users}.project_id");
		$this->db->join($this->_users, "{$this->_project_users}.user_id = {$this->_users}.id");
		$this->db->join($this->_profile, "{$this->_users}.id = {$this->_profile}.user_id");
		
		$this->db->where("{$this->_projects}.project_id", $id);
		
		if(!$nogroup)
			$this->db->where("{$this->_users}.group_id", $group_id);
			
			
		$this->db->group_by("{$this->_users}.id");	
		
		$query = $this->db->get($this->_project_users);
		
		return $query->result();
	}
	
	public function create_project($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_projects);
		
		return $this->db->insert_id();
	}
	
	public function update_project($id, $data)
	{
		$this->db->set($data);
		$this->db->where("project_id", $id);
		$this->db->update($this->_projects);
	}
	
	public function create_project_user($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_project_users);
	}
	
	public function delete_project_user($id, $user_id)
	{
		$this->db->delete($this->_project_users, array('project_id' => $id, 'user_id' => $user_id));
	}
	
}
 
/* End of file  projects_model.php */