<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Project name
 *
 * File description
 *
 * @author		Ulugbek D.
 * @since		Version 1.0
 * @filesource
 */

class Tasks_model extends CI_Model
{	
	private $_projects = 'projects';
	
	private $_project_users = 'project_users';
	
	private $_tasks = 'tasks';
	
	private $_lists = 'task_lists';
	
	private $_comments = 'task_comments';
	
	private $_users = 'users';
	
	private $_profile = 'users_profile';
	
	public function __construct()
	{
		parent::__construct();
	}
	
	public function get_list_tasks($list_id, $status=FALSE, $limit = 0, $offset = 0)
	{
		$this->db->select("{$this->_tasks}.*");
		$this->db->select("COUNT({$this->_comments}.comment_id) as comment_count");
		
		$this->db->join($this->_comments, "{$this->_comments}.task_id = {$this->_tasks}.task_id", "LEFT");
				
		$this->db->where("list_id", $list_id);
		
		if($status)
			$this->db->where("{$this->_tasks}.status", $status);
		
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		
		if($status)
			$this->db->order_by("{$this->_tasks}.status, completed_time ASC");
		else	
			$this->db->order_by("{$this->_tasks}.status, completed_time ASC, {$this->_tasks}.created DESC");
			
		$this->db->group_by("{$this->_tasks}.task_id");	
			
		$query = $this->db->get($this->_tasks);
		
		return $query->result();
	}
	
	public function get_total_list_tasks($list_id)
	{
		return $this->db->where("list_id", $list_id)->count_all($this->_tasks);
	}
	
	public function get_task($id)
	{		
		$this->db->where("task_id", $id);
		
		$query = $this->db->get($this->_tasks);
		return $query->row();
	}
	
	public function create_task($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_tasks);
		
		return $this->db->insert_id();
	}
	
	public function update_task($id, $data)
	{
		$this->db->set($data);
		$this->db->where("task_id", $id);
		$this->db->update($this->_tasks);
	}
	
	public function delete_task($id)
	{		
		$this->db->delete($this->_tasks, array('task_id' => $id));
	}
	
	/* comments */
	
	public function get_task_comments($task_id, $limit = 0, $offset = 0)
	{
		$this->db->select("{$this->_tasks}.*,{$this->_comments}.*,{$this->_users}.username");
		
		$this->db->join($this->_tasks, "{$this->_comments}.task_id = {$this->_tasks}.task_id");		
		$this->db->join($this->_users, "{$this->_users}.id = {$this->_comments}.user_id");
		
		$this->db->where("{$this->_tasks}.task_id", $task_id);
	
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		
		$this->db->order_by("{$this->_comments}.created DESC");
		
		$query = $this->db->get($this->_comments);
		
		return $query->result();
	}
	
	public function get_comment($id)
	{		
		$this->db->where("comment_id", $id);
		
		$query = $this->db->get($this->_comments);
		return $query->row();
	}	
	
	public function create_comment($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_comments);
		
		return $this->db->insert_id();
	}
	
	public function update_comment($id, $data)
	{
		$this->db->set($data);
		$this->db->where("comment_id", $id);
		$this->db->update($this->_comments);
	}
	
	public function delete_comment($id)
	{		
		$this->db->delete($this->_comments, array('comment_id' => $id));
	}
	
	/* lists */
	
	public function get_project_lists($project_id, $limit = 0, $offset = 0)
	{
		$this->db->where("project_id", $project_id);
		
		if($limit>0 && $offset>=0)
		{
			$this->db->limit($limit, $offset);
		}
		
		$this->db->order_by("created DESC");
		
		$query = $this->db->get($this->_lists);
		
		return $query->result();
	}
	
	public function get_total_project_lists($project_id)
	{
		return $this->db->where("project_id", $project_id)->count_all($this->_lists);
	}
	
	public function get_list($id)
	{		
		$this->db->where("list_id", $id);
		
		$query = $this->db->get($this->_lists);
		return $query->row();
	}
		
	public function create_list($data)
	{
		$this->db->set($data);
		$this->db->insert($this->_lists);
		
		return $this->db->insert_id();
	}
	
	public function update_list($id, $data)
	{
		$this->db->set($data);
		$this->db->where("project_id", $id);
		$this->db->update($this->_lists);
	}
	
	public function delete_list($id)
	{		
		$this->db->delete($this->_lists, array('list_id' => $id));
	}
	
	
	
}
 
/* End of file  tasks_model.php */