<h2><?php echo $project->title?> Files</h2>
<ul class="tools nav nav-pills pull-right">
	<li class="active"><a href="<?php echo site_url("p/{$project->alias}/files/add")?>">Upload new File</a></li>
</ul>

<div class="files">
	<?php if($files):?>
	<?php $date = '';?>
	<div class="file-list">
		<?php foreach($files as $file):?>
		<?php if($date != $file->date):?>
		<div class="date"><?php echo $file->date?></div>
		<?php endif?>
		<div class="row list <?php echo $file->extension?>">
			<div class="type span1"><a href="<?php echo site_url('/files/'.$file->project_id.'/'.$file->filename)?>" target="_blank"><img src="/public/images/icons/<?php echo $file->extension?>.png" /></a></div>
			<div class="body span10">
				<h4><a href="<?php echo site_url('/files/'.$file->project_id.'/'.$file->filename)?>" target="_blank"><?php echo $file->filename?></a></h4>
				<span>
					by <?php echo $file->username?> on <?php echo date('M d, Y', strtotime($file->created))?>, <?php echo $file->size?>KB
					<?php if(!is_null($file->comment_id)):?> - on <?php echo anchor("/p/{$project->alias}/tasks/comments/{$file->task_id}#{$file->comment_id}",character_limiter($file->comment, 20))?><?php endif?>
				</span>
			</div>		
			<div class="span1 dele">
			<?php if($this->auth->is_admin() || $file->user_id==$this->auth->get_user_id()):?>
				<a href="<?php echo site_url("p/{$project->alias}/files/delete/{$file->file_id}")?>" onclick="return confirm('Are you sure?')" title="Delete file"><i class="icon-trash"></i></a>
			<?php endif?>
			</div>	
		</div>
		<?php $date = $file->date;?>
		<?php endforeach?>
	</div>
	<?php endif?>
</div>
