<h2>Projects List</h2>

<ul class="tools nav nav-pills pull-right">
	<li class="active"><a href="<?php echo site_url('projects/create')?>">Add a new project</a></li>
</ul>

<?php if($projects):?>
<table class="table">
<thead>
	<tr>
		<th>ID</th>
		<th width="40%">Title</th>	
		<th>Created date</th>
		<th>Status</th>
		<th colspan="2" align="center">Action</th>
	</tr>
</thead>
<tbody>
	<?php foreach($projects as $project):?>
	<tr>
		<td class="id"><?php echo $project->project_id?></td>
		<td><?php echo $project->title?></td>		
		<td class="cnt"><?php echo date('M d, Y, g:ia', strtotime($project->created))?></td>
		<td class="cnt"><?php echo $project->status==1?'Active':'Completed'?></td>
		<td class="cnt"><?php echo anchor("projects/users/{$project->project_id}", "Users")?></td>
		<td class="cnt"><?php echo anchor("projects/edit/{$project->project_id}", "Edit")?></td>
	</tr>
	<?php endforeach;?>
</tbody>
</table>
<div id="pagination"><?php echo $pagination?></div>
<?php else:?>
<p>No projects yet.</p>
<?php endif?>