<h2><?php echo $project->title?> - Task Comments</h2>

<div class="view tasks">
	<?php if($task):?>
	<form id="tasks">			
		<div class="item <?php echo $task->status==2?'complete':''?>">
			<span class="check-inp"><input type="checkbox" name="task_<?php echo $task->task_id?>" id="task_<?php echo $task->task_id?>" value="<?php echo $task->task_id?>" <?php echo $task->status==2 ? 'checked="checked"' : ""?> /> <?php echo $task->task?></span> 											
			<?php if(!is_null($task->completed_time)):?><span class="date"><?php echo date('M j, g:ia', strtotime($task->completed_time))?></span><?php endif?>
			<a href="<?php echo site_url("p/{$project->alias}/tasks/comments/{$task->task_id}")?>" class="comment" title="Comments"><i class="icon-comment"></i></a>
			
			<a href="<?php echo site_url("p/{$project->alias}/tasks/delete/{$task->task_id}")?>" class="pull-right" onclick="return confirm('Are you sure?')" title="Delete"><i class="icon-remove"></i> Delete</a> 
			<span class="pull-right">&nbsp;&nbsp;&nbsp;</span> 
			<a href="<?php echo site_url("p/{$project->alias}/tasks/edit/{$task->task_id}")?>" class="inline pull-right" title="Edit"><i class="icon-edit"></i> Edit</a>
		</div>
	</form>	
	<?php endif?>

	<hr />
	
	<h4><a name="comments"></a>Task Comments (<?php echo count($comments)?>)</h4>
	<?php if($comments):?>
		<?php foreach($comments as $comment):?>
		<div class="media">
			<a class="pull-left" name="<?php echo $comment->comment_id?>">
				<img class="media-object" src="/public/images/avatar.png" />
			</a>
			<div class="media-body">
				<h4 class="media-heading"><?php echo $comment->username?> <span><?php echo date('M d, \a\t g:ia')?></span>
				<?php if($comment->user_id == $this->auth->get_user_id()):?>
					<span class="pull-right"><a href="<?php echo site_url("p/{$project->alias}/tasks/comment/delete/{$comment->comment_id}")?>" onclick="return confirm('Are you sure?')" title="Delete Comment"><i class="icon-trash"></i></a></span>
				<?php endif?>
				</h4>
				<?php echo $comment->comment?>
				<?php if($files = $this->files_model->get_comment_files($comment->comment_id)):?>	
				<br />			
				<?php foreach($files as $file):?>
					<div class="pull-left">
						<a href="<?php echo site_url('/files/'.$file->project_id.'/'.$file->filename)?>"  target="_blank">
							<img src="/public/images/icons/<?php echo $file->extension?>.png" />
							<?php echo $file->filename?>
						</a>
					</div>
				<?php endforeach?>
				<?php endif;?>				
			</div>	
		</div>
		<?php endforeach;?>
	<?php else:?>
	<p>There are no comments yet</p>	
	<?php endif?>
	<br />
	<h4>Leave a Comment</h4>
	<?php echo form_open_multipart('')?>
		<a class="pull-left" name="comment" style="padding:0 10px 0 0">
			<img class="media-object" src="/public/images/avatar.png" />
		</a>
		<div class="pull-left">
			<div id="toolbar" class="btn-group" style="display: none;">
				<a data-wysihtml5-action="change_view" class="btn" title="switch to html view"><i class="icon-edit"></i></a>
			    <a data-wysihtml5-command="bold" class="btn" title="CTRL+B"><i class="icon-bold"></i></a>
			    <a data-wysihtml5-command="italic" class="btn" title="CTRL+I"><i class="icon-italic"></i></a>
			    <a data-wysihtml5-command="underline" class="btn" title="CTRL+U"><i class="icon-text-width"></i></a>
			    <a data-wysihtml5-command="justifyLeft" class="btn"><i class="icon-align-left"></i></a>
			    <a data-wysihtml5-command="justifyCenter" class="btn"><i class="icon-align-center"></i></a>
			    <a data-wysihtml5-command="justifyRight" class="btn"><i class="icon-align-right"></i></a>
			    <a data-wysihtml5-command="insertUnorderedList" class="btn"><i class="icon-list"></i></a>
			    <a data-wysihtml5-command="insertOrderedList" class="btn"><i class="icon-th-list"></i></a>    
			</div>
			<textarea rows="6" cols="40" name="comment" id="comment" class="input-xxlarge"  placeholder="Leave a comment.." style="resize:none;border-top-left-radius:0;color:#000"><?php echo set_value('comment')?></textarea>
			<div id="file-container"></div>
			<div><input type="file" name="userfile" id="userfile" multiple="true" /></div>
			<div class="control-group">
				<button type="submit" class="btn btn-primary">Add Comment</button>
				<button type="button" class="btn btn-link" onclick="window.location='<?php echo site_url("p/{$project->alias}/tasks")?>'">Cancel</button>
			</div>
		</div>
	<?php echo form_close()?>
</div>
<script type="text/javascript" src="<?php echo base_url()?>public/js/wysihtml.min.js"></script>
<script>

var error_files = '';
$(function() {
	$('#userfile').uploadifive({
		'formData'			: {'project':'<?php echo $project->project_id?>', 'task': '<?php echo $task->task_id?>'},
		'buttonText'		: 'Attach files..',
		'auto'             	: true,
		'removeCompleted'  	: true,
		'uploadScript'		: BASE_URL+"p/<?php echo $project->alias?>/files/upload",
		'fileObjName'		: 'userfile',
		'uploadLimit'		: 0,
		'queueSizeLimit'	: 0,
		'simUploadLimit'	: 3,
		'width'				: 120,
		'onUploadError' : function(file, errorCode, errorMsg, errorString) {
			error_files += file.name+'<br />';					
        },
        'onUploadComplete' : function(file, data) {			        
        	var obj = $.parseJSON(data);
        	if(obj.code==200)
        	{
            	$("#file-container").prepend('<div class="itm"><input type="hidden" name="files[]" value="'+obj.message.id+'" /><img src="/public/images/icons/'+obj.message.ext+'.png" /> '+obj.message.name+'</div>');
        	}
        	else
        	{
				alert("There was an error while uploading file: "+obj.message);
        	}
        },		        
        'onQueueComplete' : function(uploads) {
            if(error_files!='')
            {
				$("#error").html('<div style="color:#f00">Following files were not uploaded: '+error_files+'</div>').show();
            }
            else
            {
            	$("#error").html(uploads.successful+" files successfully uploaded! ").show();
            }			            
        } 
	});
});

var wysihtml5ParserRules = {
		classes: {
			"wysiwyg-text-align-center": 1,
	        "wysiwyg-text-align-justify": 1,
	        "wysiwyg-text-align-left": 1,
	        "wysiwyg-text-align-right": 1
		},		
		tags: {
		    strong: {},
		    b:      {"rename_tag": "strong"},
		    i:      {"rename_tag": "em"},
		    em:     {},
		    br:     {},
		    p:      {},
		    div:    { "add_class": {
	            "align": "align_text"
	        }},
		    span:   {},
		    ul:     {},
		    ol:     {},
		    li:     {},        
		}
	};
	var editor = new wysihtml5.Editor("comment", {
	    toolbar:      "toolbar",
	    stylesheets:  BASE_URL+"public/css/editor.css",
	    parserRules:  wysihtml5ParserRules
	});
</script>
